<!-- Modal for On Going Transactions -->
<div id="ongoingModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
    <div class="relative top-20 mx-auto p-5 border w-11/12 max-w-6xl shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-medium text-gray-900">
                    <i class="fas fa-clock text-blue-500 mr-2"></i>
                    Transaksi On Going
                </h3>
                <button onclick="closeModal('ongoingModal')" class="text-gray-400 hover:text-gray-600">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
            
            <div class="mb-4">
                <input type="text" id="ongoingSearch" placeholder="Cari berdasarkan reservasi, peminjam, NIK, atau keterangan..." 
                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                       onkeyup="filterOngoingData()">
            </div>
            
            <div class="max-h-96 overflow-y-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">No. Reservasi</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Peminjam</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">NIK</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Lokasi Posisi</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tanggal Pinjam</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tanggal Kembali</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total Items</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Keterangan</th>
                        </tr>
                    </thead>
                    <tbody id="ongoingTableBody" class="bg-white divide-y divide-gray-200">
                        <!-- Data will be loaded here -->
                    </tbody>
                </table>
            </div>
            
            <div class="mt-4 flex justify-end">
                <button onclick="closeModal('ongoingModal')" 
                        class="px-4 py-2 bg-gray-300 text-gray-700 rounded-md hover:bg-gray-400 transition-colors duration-200">
                    Tutup
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Dipinjam Items -->
<div id="dipinjamModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
    <div class="relative top-20 mx-auto p-5 border w-11/12 max-w-7xl shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-medium text-gray-900">
                    <i class="fas fa-hand-holding text-purple-500 mr-2"></i>
                    Items yang Sedang Dipinjam
                </h3>
                <button onclick="closeModal('dipinjamModal')" class="text-gray-400 hover:text-gray-600">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
            
            <div class="mb-4">
                <input type="text" id="dipinjamSearch" placeholder="Cari berdasarkan kode barang, color, component, reservasi, peminjam, atau NIK..." 
                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                       onkeyup="filterDipinjamData()">
            </div>
            
            <div class="max-h-96 overflow-y-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Kode Barang</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Color Code</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Component</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Buyer</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Lokasi</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Rack</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">No. Reservasi</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Peminjam</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">NIK</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tgl Pinjam</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Keterangan</th>
                        </tr>
                    </thead>
                    <tbody id="dipinjamTableBody" class="bg-white divide-y divide-gray-200">
                        <!-- Data will be loaded here -->
                    </tbody>
                </table>
            </div>
            
            <div class="mt-4 flex justify-end">
                <button onclick="closeModal('dipinjamModal')" 
                        class="px-4 py-2 bg-gray-300 text-gray-700 rounded-md hover:bg-gray-400 transition-colors duration-200">
                    Tutup
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Overdue Transactions -->
<div id="overdueModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
    <div class="relative top-20 mx-auto p-5 border w-11/12 max-w-6xl shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-medium text-gray-900">
                    <i class="fas fa-exclamation-triangle text-red-500 mr-2"></i>
                    Transaksi Overdue
                </h3>
                <button onclick="closeModal('overdueModal')" class="text-gray-400 hover:text-gray-600">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
            
            <div class="mb-4">
                <input type="text" id="overdueSearch" placeholder="Cari berdasarkan reservasi, peminjam, NIK, atau lokasi..." 
                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                       onkeyup="filterOverdueData()">
            </div>
            
            <div class="max-h-96 overflow-y-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">No. Reservasi</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Peminjam</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">NIK</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Lokasi Posisi</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Items</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tgl Seharusnya Kembali</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Keterlambatan</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status Waktu</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Keterangan</th>
                        </tr>
                    </thead>
                    <tbody id="overdueTableBody" class="bg-white divide-y divide-gray-200">
                        <!-- Data will be loaded here -->
                    </tbody>
                </table>
            </div>
            
            <div class="mt-4 flex justify-end">
                <button onclick="closeModal('overdueModal')" 
                        class="px-4 py-2 bg-gray-300 text-gray-700 rounded-md hover:bg-gray-400 transition-colors duration-200">
                    Tutup
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Renew Items -->
<div id="renewModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
    <div class="relative top-20 mx-auto p-5 border w-11/12 max-w-5xl shadow-lg rounded-md bg-white">
        <div class="mt-3">
            <div class="flex items-center justify-between mb-4">
                <h3 class="text-lg font-medium text-gray-900">
                    <i class="fas fa-redo text-yellow-500 mr-2"></i>
                    Items yang Perlu Renew
                </h3>
                <button onclick="closeModal('renewModal')" class="text-gray-400 hover:text-gray-600">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
            
            <div class="mb-4">
                <input type="text" id="renewSearch" placeholder="Cari berdasarkan kode barang, color, atau component..." 
                       class="w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500"
                       onkeyup="filterRenewData()">
            </div>
            
            <div class="max-h-96 overflow-y-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Kode Barang</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Color Code</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Component</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Buyer</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tgl Kedaluwarsa</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status Expired</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Lokasi</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Keterangan</th>
                        </tr>
                    </thead>
                    <tbody id="renewTableBody" class="bg-white divide-y divide-gray-200">
                        <!-- Data will be loaded here -->
                    </tbody>
                </table>
            </div>
            
            <div class="mt-4 flex justify-end">
                <button onclick="closeModal('renewModal')" 
                        class="px-4 py-2 bg-gray-300 text-gray-700 rounded-md hover:bg-gray-400 transition-colors duration-200">
                    Tutup
                </button>
            </div>
        </div>
    </div>
</div>

<style>
/* Styling untuk link reservasi */
.reservation-link {
    color: #7c3aed;
    text-decoration: none;
    font-weight: 600;
    border-bottom: 1px dashed #7c3aed;
    transition: all 0.3s ease;
    padding: 2px 4px;
    border-radius: 4px;
    display: inline-flex;
    align-items: center;
    gap: 4px;
}

.reservation-link:hover {
    color: #5b21b6;
    background-color: #f3f4f6;
    border-bottom: 1px solid #5b21b6;
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

.reservation-link i {
    font-size: 0.75rem;
    opacity: 0.7;
}

.reservation-link:hover i {
    opacity: 1;
}

/* Styling untuk NIK */
.nik-cell {
    font-family: 'Courier New', monospace;
    font-size: 0.875rem;
    color: #374151;
    background-color: #f9fafb;
    padding: 4px 8px;
    border-radius: 4px;
    border: 1px solid #e5e7eb;
    font-weight: 500;
    min-width: 80px;
    text-align: center;
}

/* Badge untuk status expired */
.status-expired-badge {
    padding: 2px 8px;
    border-radius: 12px;
    font-size: 0.75rem;
    font-weight: 600;
    text-transform: uppercase;
}

.status-expired {
    background-color: #fee2e2;
    color: #dc2626;
}

.status-akan-expired {
    background-color: #fef3c7;
    color: #d97706;
}

.status-normal {
    background-color: #dcfce7;
    color: #16a34a;
}

/* Responsiveness untuk table */
@media (max-width: 768px) {
    .modal-table {
        font-size: 0.75rem;
    }
    
    .px-6 {
        padding-left: 0.75rem !important;
        padding-right: 0.75rem !important;
    }
    
    .py-3 {
        padding-top: 0.5rem !important;
        padding-bottom: 0.5rem !important;
    }
}
</style>

<script>
// Global variables to store original data
let ongoingData = [];
let dipinjamData = [];
let overdueData = [];
let renewData = [];

// Function to create reservation link
function createReservationLink(reservationNumber) {
    if (!reservationNumber) return '<span class="text-gray-400">-</span>';
    
    return `<a href="persetujuan_formulir_it.php?show_reservation=${encodeURIComponent(reservationNumber)}" 
               class="reservation-link" 
               title="Klik untuk melihat detail persetujuan reservasi ${reservationNumber}"
               target="_blank">
                <i class="fas fa-external-link-alt"></i>
                ${reservationNumber}
            </a>`;
}

// Function to format NIK display
function formatNIK(nik) {
    if (!nik) return '<span class="text-gray-400">-</span>';
    return `<span class="nik-cell">${nik}</span>`;
}

// Function to create status expired badge
function createStatusExpiredBadge(status) {
    let badgeClass = 'status-normal';
    if (status === 'Expired') {
        badgeClass = 'status-expired';
    } else if (status === 'Akan Expired') {
        badgeClass = 'status-akan-expired';
    }
    
    return `<span class="status-expired-badge ${badgeClass}">${status}</span>`;
}

// Load data functions
function loadOngoingData() {
    fetch('dashboard_data.php?type=ongoing')
        .then(response => response.json())
        .then(data => {
            ongoingData = data;
            displayOngoingData(data);
        })
        .catch(error => {
            console.error('Error loading ongoing data:', error);
            document.getElementById('ongoingTableBody').innerHTML = 
                '<tr><td colspan="9" class="px-6 py-4 text-center text-gray-500">Error loading data</td></tr>';
        });
}

function loadDipinjamData() {
    fetch('dashboard_data.php?type=dipinjam')
        .then(response => response.json())
        .then(data => {
            dipinjamData = data;
            displayDipinjamData(data);
        })
        .catch(error => {
            console.error('Error loading dipinjam data:', error);
            document.getElementById('dipinjamTableBody').innerHTML = 
                '<tr><td colspan="11" class="px-6 py-4 text-center text-gray-500">Error loading data</td></tr>';
        });
}

function loadOverdueData() {
    fetch('dashboard_data.php?type=overdue')
        .then(response => response.json())
        .then(data => {
            overdueData = data;
            displayOverdueData(data);
        })
        .catch(error => {
            console.error('Error loading overdue data:', error);
            document.getElementById('overdueTableBody').innerHTML = 
                '<tr><td colspan="9" class="px-6 py-4 text-center text-gray-500">Error loading data</td></tr>';
        });
}

function loadRenewData() {
    fetch('dashboard_data.php?type=renew')
        .then(response => response.json())
        .then(data => {
            renewData = data;
            displayRenewData(data);
        })
        .catch(error => {
            console.error('Error loading renew data:', error);
            document.getElementById('renewTableBody').innerHTML = 
                '<tr><td colspan="8" class="px-6 py-4 text-center text-gray-500">Error loading data</td></tr>';
        });
}

// Display data functions
function displayOngoingData(data) {
    const tbody = document.getElementById('ongoingTableBody');
    if (data.length === 0) {
        tbody.innerHTML = '<tr><td colspan="9" class="px-6 py-4 text-center text-gray-500">Tidak ada data transaksi ongoing</td></tr>';
        return;
    }
    
    tbody.innerHTML = data.map(item => `
        <tr class="hover:bg-gray-50">
            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                ${createReservationLink(item.reservation_number)}
            </td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">${item.peminjam || '-'}</td>
            <td class="px-6 py-4 whitespace-nowrap text-sm">
                ${formatNIK(item.nik)}
            </td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">${item.lokasi_posisi || '-'}</td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">${item.tanggal_transaksi}</td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">${item.tanggal_pengembalian}</td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                <span class="px-2 py-1 bg-blue-100 text-blue-800 rounded-full text-xs font-medium">
                    ${item.total_items} items
                </span>
            </td>
            <td class="px-6 py-4 whitespace-nowrap">
                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800">
                    ${item.status_peminjaman}
                </span>
            </td>
            <td class="px-6 py-4 text-sm text-gray-500 max-w-xs truncate" title="${item.keterangan || ''}">${item.keterangan || '-'}</td>
        </tr>
    `).join('');
}

function displayDipinjamData(data) {
    const tbody = document.getElementById('dipinjamTableBody');
    if (data.length === 0) {
        tbody.innerHTML = '<tr><td colspan="11" class="px-6 py-4 text-center text-gray-500">Tidak ada items yang sedang dipinjam</td></tr>';
        return;
    }
    
    tbody.innerHTML = data.map(item => `
        <tr class="hover:bg-gray-50">
            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">${item.kode_barang}</td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">${item.code_color}</td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">${item.component_name}</td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">${item.nama_buyer}</td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">${item.lokasi}</td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">${item.rack_no || '-'}</td>
            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                ${createReservationLink(item.reservation_number)}
            </td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">${item.peminjam || '-'}</td>
            <td class="px-6 py-4 whitespace-nowrap text-sm">
                ${formatNIK(item.nik)}
            </td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">${item.tanggal_pinjam || '-'}</td>
            <td class="px-6 py-4 text-sm text-gray-500 max-w-xs truncate" title="${item.keterangan || ''}">${item.keterangan || '-'}</td>
        </tr>
    `).join('');
}

function displayOverdueData(data) {
    const tbody = document.getElementById('overdueTableBody');
    if (data.length === 0) {
        tbody.innerHTML = '<tr><td colspan="9" class="px-6 py-4 text-center text-gray-500">Tidak ada transaksi yang overdue</td></tr>';
        return;
    }
    
    tbody.innerHTML = data.map(item => `
        <tr class="hover:bg-gray-50">
            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                ${createReservationLink(item.reservation_number)}
            </td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">${item.peminjam || '-'}</td>
            <td class="px-6 py-4 whitespace-nowrap text-sm">
                ${formatNIK(item.nik)}
            </td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">${item.lokasi_posisi || '-'}</td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                <span class="px-2 py-1 bg-blue-100 text-blue-800 rounded-full text-xs font-medium">
                    ${item.total_items} items
                </span>
            </td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">${item.tanggal_pengembalian}</td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-red-600 font-medium">${item.keterlambatan}</td>
            <td class="px-6 py-4 whitespace-nowrap">
                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-red-100 text-red-800">
                    Overdue
                </span>
            </td>
            <td class="px-6 py-4 text-sm text-gray-500 max-w-xs truncate" title="${item.keterangan || ''}">${item.keterangan || '-'}</td>
        </tr>
    `).join('');
}

function displayRenewData(data) {
    const tbody = document.getElementById('renewTableBody');
    if (data.length === 0) {
        tbody.innerHTML = '<tr><td colspan="8" class="px-6 py-4 text-center text-gray-500">Tidak ada items yang perlu renew</td></tr>';
        return;
    }
    
    tbody.innerHTML = data.map(item => `
        <tr class="hover:bg-gray-50">
            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">${item.kode_barang}</td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">${item.code_color}</td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">${item.component_name}</td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">${item.nama_buyer}</td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">${item.tanggal_kedaluwarsa}</td>
            <td class="px-6 py-4 whitespace-nowrap text-sm">
                ${createStatusExpiredBadge(item.status_expired)}
            </td>
            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">${item.lokasi}</td>
            <td class="px-6 py-4 text-sm text-gray-500 max-w-xs truncate" title="${item.keterangan || ''}">${item.keterangan || '-'}</td>
        </tr>
    `).join('');
}

// Filter functions
function filterOngoingData() {
    const searchTerm = document.getElementById('ongoingSearch').value.toLowerCase();
    const filteredData = ongoingData.filter(item => 
        (item.reservation_number && item.reservation_number.toLowerCase().includes(searchTerm)) ||
        (item.peminjam && item.peminjam.toLowerCase().includes(searchTerm)) ||
        (item.nik && item.nik.toLowerCase().includes(searchTerm)) ||
        (item.lokasi_posisi && item.lokasi_posisi.toLowerCase().includes(searchTerm)) ||
        (item.keterangan && item.keterangan.toLowerCase().includes(searchTerm))
    );
    displayOngoingData(filteredData);
}

function filterDipinjamData() {
    const searchTerm = document.getElementById('dipinjamSearch').value.toLowerCase();
    const filteredData = dipinjamData.filter(item => 
        (item.kode_barang && item.kode_barang.toLowerCase().includes(searchTerm)) ||
        (item.code_color && item.code_color.toLowerCase().includes(searchTerm)) ||
        (item.component_name && item.component_name.toLowerCase().includes(searchTerm)) ||
        (item.nama_buyer && item.nama_buyer.toLowerCase().includes(searchTerm)) ||
        (item.reservation_number && item.reservation_number.toLowerCase().includes(searchTerm)) ||
        (item.peminjam && item.peminjam.toLowerCase().includes(searchTerm)) ||
        (item.nik && item.nik.toLowerCase().includes(searchTerm)) ||
        (item.keterangan && item.keterangan.toLowerCase().includes(searchTerm))
    );
    displayDipinjamData(filteredData);
}

function filterOverdueData() {
    const searchTerm = document.getElementById('overdueSearch').value.toLowerCase();
    const filteredData = overdueData.filter(item => 
        (item.reservation_number && item.reservation_number.toLowerCase().includes(searchTerm)) ||
        (item.peminjam && item.peminjam.toLowerCase().includes(searchTerm)) ||
        (item.nik && item.nik.toLowerCase().includes(searchTerm)) ||
        (item.lokasi_posisi && item.lokasi_posisi.toLowerCase().includes(searchTerm)) ||
        (item.keterangan && item.keterangan.toLowerCase().includes(searchTerm))
    );
    displayOverdueData(filteredData);
}

function filterRenewData() {
    const searchTerm = document.getElementById('renewSearch').value.toLowerCase();
    const filteredData = renewData.filter(item => 
        (item.kode_barang && item.kode_barang.toLowerCase().includes(searchTerm)) ||
        (item.code_color && item.code_color.toLowerCase().includes(searchTerm)) ||
        (item.component_name && item.component_name.toLowerCase().includes(searchTerm)) ||
        (item.nama_buyer && item.nama_buyer.toLowerCase().includes(searchTerm)) ||
        (item.keterangan && item.keterangan.toLowerCase().includes(searchTerm))
    );
    displayRenewData(filteredData);
}
</script>