<?php

namespace App\Http\Controllers\Product;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ProductDrawer;
use Illuminate\Support\Facades\Validator;

class ProductDrawerController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $drawers = ProductDrawer::orderBy('material_type')
                                ->orderBy('drawer_type')
                                ->orderBy('width')
                                ->orderBy('length')
                                ->get();
        return view('product.drawer.index', compact('drawers'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('product.drawer.crud', ['drawer' => null]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'material_type' => 'required|string',
            'drawer_type' => 'required|string',
            'width' => 'required|numeric|min:0',
            'length' => 'required|numeric|min:0',
            'm2' => 'required|numeric|min:0',
            'price' => 'required|numeric|min:0',
        ], [
            'material_type.required' => 'Tipe material harus diisi',
            'drawer_type.required' => 'Tipe drawer harus diisi',
            'width.required' => 'Lebar harus diisi',
            'width.numeric' => 'Lebar harus berupa angka',
            'width.min' => 'Lebar tidak boleh negatif',
            'length.required' => 'Panjang harus diisi',
            'length.numeric' => 'Panjang harus berupa angka',
            'length.min' => 'Panjang tidak boleh negatif',
            'm2.required' => 'M2 harus diisi',
            'm2.numeric' => 'M2 harus berupa angka',
            'm2.min' => 'M2 tidak boleh negatif',
            'price.required' => 'Harga harus diisi',
            'price.numeric' => 'Harga harus berupa angka',
            'price.min' => 'Harga tidak boleh negatif',
        ]);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        ProductDrawer::create($request->all());

        return redirect()->route('product.drawer.index')
            ->with('success', 'Product Drawer berhasil ditambahkan!');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $drawer = ProductDrawer::findOrFail($id);
        return view('product.drawer.crud', compact('drawer'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'material_type' => 'required|string',
            'drawer_type' => 'required|string',
            'width' => 'required|numeric|min:0',
            'length' => 'required|numeric|min:0',
            'm2' => 'required|numeric|min:0',
            'price' => 'required|numeric|min:0',
        ], [
            'material_type.required' => 'Tipe material harus diisi',
            'drawer_type.required' => 'Tipe drawer harus diisi',
            'width.required' => 'Lebar harus diisi',
            'width.numeric' => 'Lebar harus berupa angka',
            'width.min' => 'Lebar tidak boleh negatif',
            'length.required' => 'Panjang harus diisi',
            'length.numeric' => 'Panjang harus berupa angka',
            'length.min' => 'Panjang tidak boleh negatif',
            'm2.required' => 'M2 harus diisi',
            'm2.numeric' => 'M2 harus berupa angka',
            'm2.min' => 'M2 tidak boleh negatif',
            'price.required' => 'Harga harus diisi',
            'price.numeric' => 'Harga harus berupa angka',
            'price.min' => 'Harga tidak boleh negatif',
        ]);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        $drawer = ProductDrawer::findOrFail($id);
        $drawer->update($request->all());

        return redirect()->route('product.drawer.index')
            ->with('success', 'Product Drawer berhasil diupdate!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $drawer = ProductDrawer::findOrFail($id);
        $drawer->delete();

        return redirect()->route('product.drawer.index')
            ->with('success', 'Product Drawer berhasil dihapus!');
    }
}