<?php

namespace App\Http\Controllers\Product;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ProductSolid;
use Illuminate\Support\Facades\Validator;

class ProductSolidController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $solids = ProductSolid::orderBy('solid_type')->orderBy('thickness')->get();
        return view('product.solid.index', compact('solids'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('product.solid.crud', ['solid' => null]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'solid_type' => 'required|string',
            'thickness' => 'required|numeric|min:0',
            'price' => 'required|numeric|min:0',
        ], [
            'solid_type.required' => 'Tipe solid harus diisi',
            'thickness.required' => 'Tebal harus diisi',
            'thickness.numeric' => 'Tebal harus berupa angka',
            'thickness.min' => 'Tebal tidak boleh negatif',
            'price.required' => 'Harga harus diisi',
            'price.numeric' => 'Harga harus berupa angka',
            'price.min' => 'Harga tidak boleh negatif',
        ]);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        ProductSolid::create($request->all());

        return redirect()->route('product.solid.index')
            ->with('success', 'Product Solid berhasil ditambahkan!');
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $solid = ProductSolid::findOrFail($id);
        return view('product.solid.crud', compact('solid'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'solid_type' => 'required|string',
            'thickness' => 'required|numeric|min:0',
            'price' => 'required|numeric|min:0',
        ], [
            'solid_type.required' => 'Tipe solid harus diisi',
            'thickness.required' => 'Tebal harus diisi',
            'thickness.numeric' => 'Tebal harus berupa angka',
            'thickness.min' => 'Tebal tidak boleh negatif',
            'price.required' => 'Harga harus diisi',
            'price.numeric' => 'Harga harus berupa angka',
            'price.min' => 'Harga tidak boleh negatif',
        ]);

        if ($validator->fails()) {
            return redirect()->back()
                ->withErrors($validator)
                ->withInput();
        }

        $solid = ProductSolid::findOrFail($id);
        $solid->update($request->all());

        return redirect()->route('product.solid.index')
            ->with('success', 'Product Solid berhasil diupdate!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy($id)
    {
        $solid = ProductSolid::findOrFail($id);
        $solid->delete();

        return redirect()->route('product.solid.index')
            ->with('success', 'Product Solid berhasil dihapus!');
    }
}