<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Fitting extends Model
{
    use HasFactory;

    protected $table = 'fitting';

    protected $fillable = [
        'material_code',
        'fitting_type',
        'material_description',
        'price'
    ];

    protected $casts = [
        'price' => 'decimal:2'
    ];

    /**
     * Scope: Filter by fitting type
     */
    public function scopeByType($query, $type)
    {
        return $query->where('fitting_type', $type);
    }

    /**
     * Scope: Search by material code or description
     */
    public function scopeSearch($query, $search)
    {
        return $query->where(function($q) use ($search) {
            $q->where('material_code', 'LIKE', "%{$search}%")
              ->orWhere('material_description', 'LIKE', "%{$search}%");
        });
    }

    /**
     * Get all unique fitting types
     */
    public static function getTypes()
    {
        return self::select('fitting_type')
            ->distinct()
            ->orderBy('fitting_type')
            ->pluck('fitting_type');
    }
}