<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvoiceBox extends Model
{
    use HasFactory;

    protected $fillable = [
        'invoice_bom_id',
        'p',
        'l',
        't',
        'box_data',
        'grand_total',
    ];

    protected $casts = [
        'p' => 'integer',
        'l' => 'integer',
        't' => 'integer',
        'box_data' => 'array',
        'grand_total' => 'decimal:2',
    ];

    /**
     * Relationship: Belongs to InvoiceBom
     */
    public function invoiceBom()
    {
        return $this->belongsTo(InvoiceBom::class);
    }

    /**
     * Get Box Components from JSON
     */
    public function getBoxComponents()
    {
        if (!$this->box_data) {
            return [];
        }

        $data = is_string($this->box_data) 
            ? json_decode($this->box_data, true) 
            : $this->box_data;

        return $data['components'] ?? [];
    }

    /**
     * Calculate Grand Total from Components
     */
    public function calculateGrandTotal()
    {
        $components = $this->getBoxComponents();
        
        return collect($components)->sum('harga');
    }

    /**
     * Get component by name
     */
    public function getComponent($name)
    {
        $components = $this->getBoxComponents();
        
        return collect($components)->firstWhere('jenis_box', $name);
    }
}