<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvoiceHandle extends Model
{
    use HasFactory;

    protected $fillable = [
        'invoice_bom_id',
        'handle_data',
        'grand_total',
    ];

    protected $casts = [
        'handle_data' => 'array',
        'grand_total' => 'decimal:2',
    ];

    /**
     * Relationship: Belongs to InvoiceBom
     */
    public function invoiceBom()
    {
        return $this->belongsTo(InvoiceBom::class);
    }

    /**
     * Get Handle Items from JSON
     */
    public function getHandleItems()
    {
        if (!$this->handle_data) {
            return [];
        }

        $data = is_string($this->handle_data) 
            ? json_decode($this->handle_data, true) 
            : $this->handle_data;

        return $data['items'] ?? [];
    }

    /**
     * Calculate Grand Total from Items
     */
    public function calculateGrandTotal()
    {
        $items = $this->getHandleItems();
        
        return collect($items)->sum('total');
    }
}