<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvoiceMetal extends Model
{
    use HasFactory;

    protected $fillable = [
        'invoice_bom_id',
        'metal_data',
        'grand_total',
    ];

    protected $casts = [
        'metal_data' => 'array',
        'grand_total' => 'decimal:2',
    ];

    /**
     * Relationship: Belongs to InvoiceBom
     */
    public function invoiceBom()
    {
        return $this->belongsTo(InvoiceBom::class);
    }

    /**
     * Get Metal Items from JSON
     */
    public function getMetalItems()
    {
        if (!$this->metal_data) {
            return [];
        }

        $data = is_string($this->metal_data) 
            ? json_decode($this->metal_data, true) 
            : $this->metal_data;

        return $data['items'] ?? [];
    }

    /**
     * Calculate Grand Total from Items
     */
    public function calculateGrandTotal()
    {
        $items = $this->getMetalItems();
        
        return collect($items)->sum('total');
    }
}