<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvoiceUkir extends Model
{
    use HasFactory;

    protected $fillable = [
        'invoice_bom_id',
        'ukir_data',
        'grand_total',
    ];

    protected $casts = [
        'ukir_data' => 'array',
        'grand_total' => 'decimal:2',
    ];

    /**
     * Relationship: Belongs to InvoiceBom
     */
    public function invoiceBom()
    {
        return $this->belongsTo(InvoiceBom::class);
    }

    /**
     * Get Ukir Items from JSON
     */
    public function getUkirItems()
    {
        if (!$this->ukir_data) {
            return [];
        }

        $data = is_string($this->ukir_data) 
            ? json_decode($this->ukir_data, true) 
            : $this->ukir_data;

        return $data['items'] ?? [];
    }

    /**
     * Calculate Grand Total from Items
     */
    public function calculateGrandTotal()
    {
        $items = $this->getUkirItems();
        
        return collect($items)->sum('total');
    }
}