<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductVeneer extends Model
{
    use HasFactory;

    protected $fillable = [
        'veneer_type',
        'thickness',
        'price_lurus',
        'price_motif'
    ];

    protected $casts = [
        'thickness' => 'decimal:2',
        'price_lurus' => 'decimal:2',
        'price_motif' => 'decimal:2'
    ];

    /**
     * Scope untuk filter berdasarkan veneer type
     */
    public function scopeByType($query, $type)
    {
        return $query->where('veneer_type', $type);
    }

    /**
     * Get price based on pattern type
     */
    public function getPriceByPattern($pattern)
    {
        return $pattern === 'LURUS' ? $this->price_lurus : $this->price_motif;
    }
}