<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('product_drawers', function (Blueprint $table) {
            $table->id();
            $table->string('material_type');
            $table->string('drawer_type')->nullable(); // ← PASTIKAN ADA INI
            $table->decimal('width', 8, 2);
            $table->decimal('length', 8, 2);
            $table->decimal('m2', 10, 4);
            $table->decimal('price', 15, 2);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('product_drawers');
    }
};