<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoice_handles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('invoice_bom_id')->constrained('invoice_boms')->onDelete('cascade');
            $table->json('handle_data'); // Manual items JSON
            $table->decimal('grand_total', 15, 2)->default(0);
            $table->timestamps();
            
            // Ensure one handle invoice per BOM
            $table->unique('invoice_bom_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoice_handles');
    }
};