<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoice_boxes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('invoice_bom_id')->constrained('invoice_boms')->onDelete('cascade');
            
            // Dimensi produk dari Invoice BOM
            $table->integer('p'); // Panjang (dari size Invoice BOM)
            $table->integer('l'); // Lebar (dari size Invoice BOM)
            $table->integer('t'); // Tinggi (dari size Invoice BOM)
            
            // Data perhitungan 9 komponen (JSON)
            $table->json('box_data'); // Array of 9 components with calculations
            
            // Grand Total
            $table->decimal('grand_total', 15, 2);
            
            $table->timestamps();
            
            // Ensure one box invoice per BOM
            $table->unique('invoice_bom_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoice_boxes');
    }
};