<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('invoice_boms', function (Blueprint $table) {
            // ✅ Add M³ & Biaya Produksi columns
            $table->decimal('total_m3', 15, 6)->nullable()->after('grand_total');
            $table->decimal('harga_per_m3', 15, 2)->nullable()->after('total_m3');
            $table->decimal('biaya_produksi', 15, 2)->nullable()->after('harga_per_m3');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('invoice_boms', function (Blueprint $table) {
            $table->dropColumn(['total_m3', 'harga_per_m3', 'biaya_produksi']);
        });
    }
};