<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class FittingSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $fittingData = [
            // ============================================
            // COUNTER WEIGHT
            // ============================================
            ['material_code' => '', 'fitting_type' => 'Counter Weight', 'material_description' => 'COUNTER WEIGHT', 'price' => 41250],

            // ============================================
            // FITTING RAIL
            // ============================================
            ['material_code' => 'RHSSLR00046', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL TNDM 561H2601B TA L FULL EXT 260', 'price' => 105806],
            ['material_code' => 'RHSSLR00047', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL TNDM 561H2601B TA R FULL EXT 260', 'price' => 105806],
            ['material_code' => 'RHSSLR00048', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL TNDM 561H3101B TA L FULL EXT 310', 'price' => 105188],
            ['material_code' => 'RHSSLR00049', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL TNDM 561H3101B TA R FULL EXT 310', 'price' => 105188],
            ['material_code' => 'RHSSLR00050', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL TNDM 561H3601B TA L FULL EXT 360', 'price' => 106838],
            ['material_code' => 'RHSSLR00051', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL TNDM 561H3601B TA R FULL EXT 360', 'price' => 106838],
            ['material_code' => 'RHSSLR00052', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL TNDM 561H4101B TA L FULL EXT 410', 'price' => 106012],
            ['material_code' => 'RHSSLR00053', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL TNDM 561H4101B TA R FULL EXT 410', 'price' => 106012],
            ['material_code' => 'RHSSLR00054', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL TNDM 561H4601B TA L FULL EXT 460', 'price' => 107456],
            ['material_code' => 'RHSSLR00055', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL TNDM 561H4601B TA R FULL EXT 460', 'price' => 107456],
            ['material_code' => 'RHSSLR00040', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL TNDM 551H3601B TA L SINGLE EXT 360', 'price' => 45788],
            ['material_code' => 'RHSSLR00041', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL TNDM 551H3601B TA R SINGLE EXT 360', 'price' => 45788],
            ['material_code' => 'RHSSLR00043', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL TNDM 551H4101B TA R SINGLE EXT 410', 'price' => 45788],
            ['material_code' => 'RHSSLR00042', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL TNDM 551H4101B TA L SINGLE EXT 410', 'price' => 45788],
            ['material_code' => 'RHSSLR00044', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL TNDM 551H4601B TA L SINGLE EXT 460', 'price' => 47231],
            ['material_code' => 'RHSSLR00045', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL TNDM 551H4601B TA R SINGLE EXT 460', 'price' => 47231],
            ['material_code' => 'RHSSLR00002', 'fitting_type' => 'Fitting Rail', 'material_description' => 'COUPLING HA L/H QUADRO 9144830', 'price' => 3712],
            ['material_code' => 'RHSSLR00003', 'fitting_type' => 'Fitting Rail', 'material_description' => 'COUPLING HA R/H QUADRO 9144831', 'price' => 3712],
            ['material_code' => 'RHSSLR00024', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL QUADRO SILENT SYSTEM LEFT V6/350', 'price' => 97969],
            ['material_code' => 'RHSSLR00025', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL QUADRO SILENT SYSTEM RIHGT V6/350', 'price' => 97969],
            ['material_code' => 'RHSSLR00018', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL QUADRO PUSH TO OPEN 9114520 L 350', 'price' => 51769],
            ['material_code' => 'RHSSLR00019', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL QUADRO PUSH TO OPEN 9114521 R 350', 'price' => 51769],
            ['material_code' => 'RHSSLR00020', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL QUADRO PUSH TO OPEN 9114522 L 400', 'price' => 49912],
            ['material_code' => 'RHSSLR00021', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL QUADRO PUSH TO OPEN 9114524 R 400', 'price' => 49912],
            ['material_code' => '40000772', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL TNDM SILENT HAF 433.07.225 16/250MM', 'price' => 71362],
            ['material_code' => '40000325', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL TNDM SILENT HAF 433.07.230 16/300', 'price' => 76312],
            ['material_code' => 'RHSSLR00081', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL TNDM SILENT HAF 433.07.235 16/350', 'price' => 69712],
            ['material_code' => 'RHSSLR00078', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL TNDM SILENT HAF 433.07.240 16/400', 'price' => 81262],
            ['material_code' => '40000769', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL TNDM SILENT HAF 433.07.245 16/450MM', 'price' => 87450],
            ['material_code' => 'RHSSLR00012', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL BLBRNG FULL EXT HUBEN 14" BLK', 'price' => 23306],
            ['material_code' => 'RHSSLR00009', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL BLBRNG FULL EXT HUBEN 16" BLK', 'price' => 26606],
            ['material_code' => 'RHSSLR00010', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL BLBRNG FULL EXT HUBEN 18" BLK', 'price' => 30112],
            ['material_code' => 'RHSSLR00013', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL HEAVY DUTY DRW #OH6312 14 INCH BLK', 'price' => 110344],
            ['material_code' => 'RHSSLR00007', 'fitting_type' => 'Fitting Rail', 'material_description' => 'GEAR MECHANISM V0162 43X595MM BLK OVS', 'price' => 76312],
            ['material_code' => 'RHSSLR00005', 'fitting_type' => 'Fitting Rail', 'material_description' => 'GEAR MECHANISM V0162 828MM BLK DMT', 'price' => 111994],
            ['material_code' => 'RHSSLR00056', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL WATERTOWN 6-48-25-46-S250PB 48" SLV', 'price' => 792000],
            ['material_code' => '40000898', 'fitting_type' => 'Fitting Rail', 'material_description' => 'RAIL WATERTOWN 6-60-39-42-S250RB 60" SLV', 'price' => 1438800],

            // ============================================
            // FITTING HINGE
            // ============================================
            ['material_code' => 'RHSHNG00008', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'CNCLD HINGE BLUM 70T9750.TL 95° INSET', 'price' => 22275],
            ['material_code' => 'RHSHNG00007', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'CNCLD HINGE BLUM 70T7650.TL CLP TOP 155°', 'price' => 64350],
            ['material_code' => 'RHSHNG00009', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'CNCLD HINGE BLUM 71T6550 CLIP TOP 170°', 'price' => 37538],
            ['material_code' => 'RHSHNG00012', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'CNCLD HINGE BLUM 71T9750 INSERT', 'price' => 23719],
            ['material_code' => 'RHSHNG00010', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'CNCLD HINGE BLUM 71T9550 FULL OVERLAY', 'price' => 19388],
            ['material_code' => 'RHSHNG00011', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'CNCLD HINGE BLUM 71T9650 HALF OVERLAY', 'price' => 22894],
            ['material_code' => 'RHSHNG00049', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'CNCLD HINGE BLUM 70T9650.TL HALF OVERLAY', 'price' => 22949],
            ['material_code' => '40001633', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'CNCLD HINGE BLUM BLUMOTION 71B7550D CLIP', 'price' => 85181],
            ['material_code' => 'RHSHNG00014', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'CNCLD HINGE BLUM BLUMOTION 71B9750 INST', 'price' => 38775],
            ['material_code' => 'RHSHNG00013', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'CNCLD HINGE BLUM BLUMOTION 71B9550 OVRLY', 'price' => 35888],
            ['material_code' => '40001561', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'CNCLD HINGE HAF 315.08.652 INSERT', 'price' => 14438],
            ['material_code' => '40001563', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'CNCLD HINGE HAF 315.08.650 FULL OVERLAY', 'price' => 12581],
            ['material_code' => '40001562', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'CNCLD HINGE HAF 315.08.651 HALF OVERLAY', 'price' => 13406],
            ['material_code' => 'RHSHNG00043', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'MOUNTING PLATE BLUM 175H7100 THCK 0 MM', 'price' => 6600],
            ['material_code' => 'RHSHNG00040', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'MOUNTING PLATE 72984/107160600 SLVR', 'price' => 3300],
            ['material_code' => 'RHSHNG00046', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'MOUNTING PLATE BLM 175L8190.21 THCK 11MM', 'price' => 13819],
            ['material_code' => 'RHSHNG00044', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'MOUNTING PLATE BLM 175H9160 THCK 6 MM', 'price' => 10725],
            ['material_code' => 'RHSHNG00045', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'MOUNTING PLATE BLM 173L8130 THCK 3MM', 'price' => 3506],
            ['material_code' => 'RHSHNG00042', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'MOUNTING PLATE BLM 173L6100 THCK 0 MM', 'price' => 2062],
            ['material_code' => '40001656', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'MOUNTING PLATE HAF 315.98.552 THCK 2MM', 'price' => 1444],
            ['material_code' => '40001657', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'MOUNTING PLATE HAF 315.98.550 THCK 0MM', 'price' => 1650],
            ['material_code' => 'RHSHNG00047', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'OUTSIDE DOOR HINGE RH1590 ANT.BRASS', 'price' => 16500],
            ['material_code' => 'RHSHNG00032', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'HINGE T65034 1 #504  OVS', 'price' => 50325],
            ['material_code' => 'RHSHNG00005', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'BUTT HINGE RH1583 SILVER', 'price' => 14850],
            ['material_code' => '40001459', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'PIANO HINGE SS 1X32X1800MM', 'price' => 100856],
            ['material_code' => 'RHSHNG00080', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'PIANO HINGE H012 BRSHD BRS 1.2X36X812MM', 'price' => 154275],
            ['material_code' => 'RHSHNG00015', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'CNCLD HINGE H0299 44MM CHRM PLATE DMT', 'price' => 35062],
            ['material_code' => 'RHSHNG00030', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'HINGE S-3595 90 DEG #504 FIN OVS', 'price' => 42281],
            ['material_code' => 'RHSHNG00031', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'HINGE S-3648 120 DEG #504 FIN OVS', 'price' => 45375],
            ['material_code' => '40001634', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'ANGLE RESTRICTION BLUM 70T7553 CLIP 110', 'price' => 4744],
            ['material_code' => 'RHSHNG00001', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'BALL TIP HINGE RH1584 ANT.BRASS', 'price' => 14850],
            ['material_code' => 'RHSHNG00004', 'fitting_type' => 'Fitting Hinge', 'material_description' => 'BUTT HINGE RH1583 ANTIQUE BRASS', 'price' => 14850],
            // ============================================
            // FITTING RUBBER
            // ============================================
            ['material_code' => 'RHSSTO00015', 'fitting_type' => 'Fitting Rubber', 'material_description' => 'SUPERSPEED RUBBER 41" (1041MM) OVS', 'price' => 168919],
            ['material_code' => 'RHSSTO00016', 'fitting_type' => 'Fitting Rubber', 'material_description' => 'SUPERSPEED RUBBER 47" (1194MM) OVS', 'price' => 184181],
            ['material_code' => 'RHAMTL00057', 'fitting_type' => 'Fitting Rubber', 'material_description' => 'GCVI SIDE APRON BRUSHED NICKEL 50"', 'price' => 206869],
            ['material_code' => 'RHAMTL00056', 'fitting_type' => 'Fitting Rubber', 'material_description' => 'GCVI END APRON BRUSHED NICKEL 56"', 'price' => 233269],
            ['material_code' => 'RHAMTL00055', 'fitting_type' => 'Fitting Rubber', 'material_description' => 'GCVI SIDE RAIL BRUSHED NICKEL  50"', 'price' => 208931],
            ['material_code' => 'RHAMTL00091', 'fitting_type' => 'Fitting Rubber', 'material_description' => 'GCVI END RAIL BRUSHED NICKEL  56"', 'price' => 243994],

            // ============================================
            // FITTING LED & DIMMER
            // ============================================
            ['material_code' => 'RHADIM00055', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FC-498-TRANS-36W', 'price' => 434981],
            ['material_code' => 'RHADIM00054', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'ZH AF JUNCTON1-W/ 1 1/4" SCREWS', 'price' => 106219],
            ['material_code' => 'RHADIM00053', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'F-TL-POWER-JUMP', 'price' => 33619],
            ['material_code' => 'RHADIM00049', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'ADAPTER MAP5V1A002', 'price' => 72600],
            ['material_code' => 'RHADIM00048', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'LED U30W2W-0012', 'price' => 165206],
            ['material_code' => 'RHADIM00047', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'COVE TR 2 OUTLETS #ECOV-TR-2-GW108 WHITE', 'price' => 206],
            ['material_code' => 'RHADIM00046', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FURNLITE FC-542 ROCKER SWITCH ON/OFF', 'price' => 94875],
            ['material_code' => 'RHADIM00045', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'CCC POWER STRIP TBU 4008U', 'price' => 236362],
            ['material_code' => 'RHADIM00044', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FURNLITE FC-450 PUCK LIGHT OVS', 'price' => 90131],
            ['material_code' => 'RHADIM00043', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FC-880-84 TERMNL RNG LEAD WIRE HRNSS 84"', 'price' => 206],
            ['material_code' => 'RHADIM00042', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'CABLE CLIP 9805912 TYPE B OVS', 'price' => 1650],
            ['material_code' => 'RHADIM00041', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FURNLITE FC-498-TRANS-24W OVS', 'price' => 292875],
            ['material_code' => 'RHADIM00040', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'TOUCH BUTTON FC-883-BS OVS', 'price' => 14025],
            ['material_code' => 'RHADIM00039', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'PUCK LIGHT FC-493-BK OVS', 'price' => 164588],
            ['material_code' => 'RHADIM00038', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'PUCK LIGHT 201B20-C3W-12V OVS', 'price' => 78169],
            ['material_code' => 'RHADIM00037', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'LOW VOLTAGE DIMMER FC-508 OVS', 'price' => 387131],
            ['material_code' => 'RHADIM00036', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FC-880-48 TERMNL RNG LEAD WIRE HRNSS 48"', 'price' => 3919],
            ['material_code' => 'RHADIM00035', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FC-504 ON OFF TOUCH SWITCH', 'price' => 134269],
            ['material_code' => 'RHADIM00034', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FC-493 OVS', 'price' => 178200],
            ['material_code' => 'RHADIM00033', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'PUCK LIGHT FC-492-BK OVS', 'price' => 190162],
            ['material_code' => 'RHADIM00032', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FURNLITE FC-470', 'price' => 100856],
            ['material_code' => 'RHADIM00031', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FC-460 BLACK', 'price' => 77344],
            ['material_code' => 'RHADIM00030', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'EXTRA WHITE WIRE EW-12F OVS', 'price' => 15675],
            ['material_code' => 'RHADIM00029', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'DRIVER 12V-12W-681 OVS', 'price' => 97762],
            ['material_code' => 'RHADIM00028', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'DIMMER DX-613B OVS', 'price' => 35269],
            ['material_code' => 'RHADIM00027', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FURNLITE FC-475', 'price' => 83944],
            ['material_code' => 'RHADIM00026', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FURNLITE FC-101-EA BLK CANISTER LIGHT', 'price' => 79406],
            ['material_code' => 'RHADIM00025', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FURNLITE FC-100 EA BLK CANISTER LIGHT', 'price' => 94875],
            ['material_code' => 'RHADIM00024', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FC-737 BLACK WITH TWO OUTLETS ONE USB', 'price' => 286275],
            ['material_code' => 'RHADIM00023', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FURNLITE FC-752-WHITE', 'price' => 238012],
            ['material_code' => 'RHADIM00022', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FURNLITE FC-877-10" OVS', 'price' => 53006],
            ['material_code' => 'RHADIM00021', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FURNLITE FC-497-BK-6" OVS', 'price' => 133650],
            ['material_code' => 'RHADIM00020', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FURNLITE FC-498-30-TRANS OVS', 'price' => 15881],
            ['material_code' => 'RHADIM00019', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FURNLITE FC-498-TRANS-8W OVS', 'price' => 138188],
            ['material_code' => 'RHADIM00018', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FURNLITE FC-498-BK-12" OVS', 'price' => 257606],
            ['material_code' => 'RHADIM00017', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'UC-3 CABLE CLAMPS', 'price' => 1238],
            ['material_code' => 'RHADIM00016', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FC-498-12-EXTENSION', 'price' => 14644],
            ['material_code' => 'RHADIM00015', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'WM2A WLNUT BRWN 9" LONG W/DBLSDTAP 1-FT', 'price' => 83531],
            ['material_code' => 'RHADIM00014', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FURNLITE FC-511 LOW VOLTAGE DIMMER', 'price' => 457875],
            ['material_code' => 'RHADIM00013', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FC-TL-MOUNT CLIP', 'price' => 2269],
            ['material_code' => 'RHADIM00012', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'POWER PLATE FC-739 OVS', 'price' => 490669],
            ['material_code' => 'RHADIM00011', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FC-840 CABLE CLAMPS', 'price' => 1238],
            ['material_code' => 'RHADIM00010', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FC-707 BLACK THREE OUTLET ONE USB OVS', 'price' => 300094],
            ['material_code' => 'RHADIM00009', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FC-TL-96-3K TAPE LIGHT', 'price' => 202538],
            ['material_code' => 'RHADIM00008', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FC-TL-JUMP-48', 'price' => 20212],
            ['material_code' => 'RHADIM00007', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'DIMMER BLK PVC CVR MTL D SHFT FC-510', 'price' => 140869],
            ['material_code' => 'RHADIM00006', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FURNLITE IMPORT FC-498-60"-EXTENSION', 'price' => 28256],
            ['material_code' => 'RHADIM00005', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FURNLITE FC-510-EA-CCC-220V', 'price' => 292875],
            ['material_code' => 'RHADIM00004', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FURNLITE FC-101-EA-CCC-220V', 'price' => 147675],
            ['material_code' => 'RHADIM00003', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FURNLITE FC-100-EA-CCC-220V', 'price' => 179438],
            ['material_code' => 'RHADIM00002', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FURNLITE #93 FC-111 OVS', 'price' => 120450],
            ['material_code' => 'RHADIM00001', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'FURNLITE #92 FC-110 OVS', 'price' => 144169],
            ['material_code' => '40001812', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'LEDS-FLX-TD6-5A-KIT', 'price' => 3298144],
            ['material_code' => '40001711', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'LEPD-030-BK-030-TD6-KIT2 OVS', 'price' => 531094],
            ['material_code' => '40001110', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'LEDS-536-12V-F-SA-030-KIT OVS', 'price' => 834694],
            ['material_code' => '40001017', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'LED PUCK LIGHT LEDU00W', 'price' => 128906],
            ['material_code' => '40001016', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'LED PUCK LIGHT W/ EXTENSION LEDU31W-0022', 'price' => 200681],
            ['material_code' => '40000345', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'LED-TD6-BK-KIT OVS', 'price' => 80025],
            ['material_code' => '40000344', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'LEDTF-12V-1A-WP-BK TRANSFORMER OVS', 'price' => 86212],
            ['material_code' => '40000343', 'fitting_type' => 'Fitting LED & Dimmer', 'material_description' => 'LEDP-030-BK-030 LED PUCK OVS', 'price' => 82088],
            // ============================================
            // FITTING ACCESSORIES
            // ============================================
            ['material_code' => '', 'fitting_type' => 'Fitting Accessories', 'material_description' => 'HANDLE KNOB', 'price' => 61875],
            ['material_code' => '', 'fitting_type' => 'Fitting Accessories', 'material_description' => 'HANDLE PULL', 'price' => 103125],
            ['material_code' => '', 'fitting_type' => 'Fitting Accessories', 'material_description' => 'KEY', 'price' => 61875],
            ['material_code' => '', 'fitting_type' => 'Fitting Accessories', 'material_description' => 'FERRULE', 'price' => 82500],
            ['material_code' => 'RHAGRO00007', 'fitting_type' => 'Fitting Accessories', 'material_description' => 'PLASTIC TELESCOPE T03 BLK OVS', 'price' => 3919],
            ['material_code' => 'RHAGRO00004', 'fitting_type' => 'Fitting Accessories', 'material_description' => 'GROMMET EDPW3-90 2-1/2INCH BLACK OVS', 'price' => 121688],
            ['material_code' => 'RHAGRO00002', 'fitting_type' => 'Fitting Accessories', 'material_description' => 'HOLE PLUG 5/8" BLK', 'price' => 825],
            ['material_code' => 'RHADIA00006', 'fitting_type' => 'Fitting Accessories', 'material_description' => 'DIAMOND SMALL SIGHT 51207607004 BLK OVS', 'price' => 1444],
            ['material_code' => 'RHADIA00004', 'fitting_type' => 'Fitting Accessories', 'material_description' => 'DIAMOND SIGHT DARK SLVR/WHITE OVS', 'price' => 206],
            ['material_code' => 'RHADIA00002', 'fitting_type' => 'Fitting Accessories', 'material_description' => 'DIAMOND LARGE SIGHT 51207607002 WHTE OVS', 'price' => 1856],
            ['material_code' => 'RHAMTL00071', 'fitting_type' => 'Fitting Accessories', 'material_description' => 'PEDESTAL BASE 8 51215627001', 'price' => 206],
            ['material_code' => 'RHAMTL00069', 'fitting_type' => 'Fitting Accessories', 'material_description' => 'PEDESTAL END CAP 51215625001', 'price' => 206],
            ['material_code' => 'RHAMTL00068', 'fitting_type' => 'Fitting Accessories', 'material_description' => 'STRECHER HOLLOW BRASS (4230-372) DMT', 'price' => 201919],
            ['material_code' => 'RHAMTL00058', 'fitting_type' => 'Fitting Accessories', 'material_description' => 'Z BRACKET 6000 MM', 'price' => 178612],
            ['material_code' => 'RHAMTL00035', 'fitting_type' => 'Fitting Accessories', 'material_description' => '5 LEGS BASE RAV001 5X46X584MM OVS', 'price' => 339281],
            ['material_code' => '40000629', 'fitting_type' => 'Fitting Accessories', 'material_description' => 'MTL SUPPORT TATE CB 3 X 60 X 140 MM BL', 'price' => 13406],
            ['material_code' => 'RHALOC00026', 'fitting_type' => 'Fitting Accessories', 'material_description' => 'MECHANISME BLACK ZW208AJ OVS', 'price' => 82500],
            ['material_code' => 'RHALOC00024', 'fitting_type' => 'Fitting Accessories', 'material_description' => 'GASLIFT RV1420 TUV 2 CERTIFICATE OVS', 'price' => 86625],
            ['material_code' => 'RHACHM00004', 'fitting_type' => 'Fitting Accessories', 'material_description' => 'MTL SWIVEL RN0165 UK.160X160MM BLK', 'price' => 93225],
            ['material_code' => 'RHACHM00003', 'fitting_type' => 'Fitting Accessories', 'material_description' => 'MTL SWIVEL 245X2.5X22MM (N1009) BLK DMT', 'price' => 206250],
            ['material_code' => 'RHACHM00002', 'fitting_type' => 'Fitting Accessories', 'material_description' => 'MTL SWIVEL N0165 2.5X175X175MM BLK DMT', 'price' => 94875],
            ['material_code' => 'RHACST00007', 'fitting_type' => 'Fitting Accessories', 'material_description' => 'CASTER BLACK L0131 40X38X38MM', 'price' => 8662],
            ['material_code' => 'RHACST00003', 'fitting_type' => 'Fitting Accessories', 'material_description' => 'CASTER BLACK L0129 3/8X50X15MM OVS', 'price' => 7838],
            ['material_code' => 'RHASGT00006', 'fitting_type' => 'Fitting Accessories', 'material_description' => 'SCORING #ABACUS-KAO OVS', 'price' => 448800],
            ['material_code' => 'RHASGT00004', 'fitting_type' => 'Fitting Accessories', 'material_description' => 'LEATHER COASTER DIA:10CM BLK OVS', 'price' => 27844],
        ];

        DB::table('fitting')->insert($fittingData);
        
        $this->command->info('✅ Fitting data seeded successfully! Total: ' . count($fittingData) . ' items');
    }
}