<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\ProductSolid;

class ProductSolidSeeder extends Seeder
{
    public function run(): void
    {
        $solids = [
            // MAHONI
            ['solid_type' => 'MAHONI', 'thickness' => 5, 'price' => 74000],
            ['solid_type' => 'MAHONI', 'thickness' => 10, 'price' => 147000],
            ['solid_type' => 'MAHONI', 'thickness' => 15, 'price' => 220000],
            ['solid_type' => 'MAHONI', 'thickness' => 18, 'price' => 264000],
            ['solid_type' => 'MAHONI', 'thickness' => 25, 'price' => 367000],
            ['solid_type' => 'MAHONI', 'thickness' => 35, 'price' => 513000],
            ['solid_type' => 'MAHONI', 'thickness' => 40, 'price' => 586000],
            ['solid_type' => 'MAHONI', 'thickness' => 50, 'price' => 732000],
            ['solid_type' => 'MAHONI', 'thickness' => 60, 'price' => 878000],
            
            // WALNUT
            ['solid_type' => 'WALNUT', 'thickness' => 5, 'price' => 292000],
            ['solid_type' => 'WALNUT', 'thickness' => 10, 'price' => 583000],
            ['solid_type' => 'WALNUT', 'thickness' => 15, 'price' => 875000],
            ['solid_type' => 'WALNUT', 'thickness' => 18, 'price' => 1050000],
            ['solid_type' => 'WALNUT', 'thickness' => 25, 'price' => 1458000],
            ['solid_type' => 'WALNUT', 'thickness' => 35, 'price' => 2041000],
            ['solid_type' => 'WALNUT', 'thickness' => 40, 'price' => 2332000],
            ['solid_type' => 'WALNUT', 'thickness' => 50, 'price' => 2915000],
            ['solid_type' => 'WALNUT', 'thickness' => 60, 'price' => 3498000],
            
            // WHITE OAK
            ['solid_type' => 'WHITE OAK', 'thickness' => 5, 'price' => 143000],
            ['solid_type' => 'WHITE OAK', 'thickness' => 10, 'price' => 286000],
            ['solid_type' => 'WHITE OAK', 'thickness' => 15, 'price' => 429000],
            ['solid_type' => 'WHITE OAK', 'thickness' => 18, 'price' => 515000],
            ['solid_type' => 'WHITE OAK', 'thickness' => 25, 'price' => 715000],
            ['solid_type' => 'WHITE OAK', 'thickness' => 35, 'price' => 1001000],
            ['solid_type' => 'WHITE OAK', 'thickness' => 40, 'price' => 1144000],
            ['solid_type' => 'WHITE OAK', 'thickness' => 50, 'price' => 1430000],
            ['solid_type' => 'WHITE OAK', 'thickness' => 60, 'price' => 1716000],
            
            // WHITE ASH / BEECH
            ['solid_type' => 'WHITE ASH / BEECH', 'thickness' => 5, 'price' => 132000],
            ['solid_type' => 'WHITE ASH / BEECH', 'thickness' => 10, 'price' => 264000],
            ['solid_type' => 'WHITE ASH / BEECH', 'thickness' => 15, 'price' => 396000],
            ['solid_type' => 'WHITE ASH / BEECH', 'thickness' => 18, 'price' => 476000],
            ['solid_type' => 'WHITE ASH / BEECH', 'thickness' => 25, 'price' => 660000],
            ['solid_type' => 'WHITE ASH / BEECH', 'thickness' => 35, 'price' => 924000],
            ['solid_type' => 'WHITE ASH / BEECH', 'thickness' => 40, 'price' => 1056000],
            ['solid_type' => 'WHITE ASH / BEECH', 'thickness' => 50, 'price' => 1320000],
            ['solid_type' => 'WHITE ASH / BEECH', 'thickness' => 60, 'price' => 1584000],
            
            // MAPLE
            ['solid_type' => 'MAPLE', 'thickness' => 5, 'price' => 138000],
            ['solid_type' => 'MAPLE', 'thickness' => 10, 'price' => 275000],
            ['solid_type' => 'MAPLE', 'thickness' => 15, 'price' => 413000],
            ['solid_type' => 'MAPLE', 'thickness' => 18, 'price' => 495000],
            ['solid_type' => 'MAPLE', 'thickness' => 25, 'price' => 688000],
            ['solid_type' => 'MAPLE', 'thickness' => 35, 'price' => 963000],
            ['solid_type' => 'MAPLE', 'thickness' => 40, 'price' => 1100000],
            ['solid_type' => 'MAPLE', 'thickness' => 50, 'price' => 1320000],
            ['solid_type' => 'MAPLE', 'thickness' => 60, 'price' => 1584000],
            
            // JATI
            ['solid_type' => 'JATI', 'thickness' => 5, 'price' => 248000],
            ['solid_type' => 'JATI', 'thickness' => 10, 'price' => 495000],
            ['solid_type' => 'JATI', 'thickness' => 15, 'price' => 743000],
            ['solid_type' => 'JATI', 'thickness' => 18, 'price' => 891000],
            ['solid_type' => 'JATI', 'thickness' => 25, 'price' => 1238000],
            ['solid_type' => 'JATI', 'thickness' => 35, 'price' => 1733000],
            ['solid_type' => 'JATI', 'thickness' => 40, 'price' => 1980000],
            ['solid_type' => 'JATI', 'thickness' => 50, 'price' => 2475000],
            ['solid_type' => 'JATI', 'thickness' => 60, 'price' => 2970000],
        ];

        foreach ($solids as $solid) {
            ProductSolid::create($solid);
        }
    }
}