@extends('layouts.app')

@section('title', 'Dashboard - Cost Furniture')

@section('page-title', 'Dashboard')

@section('content')
<div class="row g-4">
    <!-- Statistics Cards -->
    <div class="col-xl-3 col-md-6">
        <div class="stat-card" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
            <div class="stat-icon">
                <i class="fas fa-file-invoice"></i>
            </div>
            <div class="stat-content">
                <div class="stat-number">{{ $total_invoices }}</div>
                <div class="stat-label">Total Invoice</div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6">
        <div class="stat-card" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
            <div class="stat-icon">
                <i class="fas fa-layer-group"></i>
            </div>
            <div class="stat-content">
                <div class="stat-number">{{ $total_panels }}</div>
                <div class="stat-label">Product Panel</div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6">
        <div class="stat-card" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);">
            <div class="stat-icon">
                <i class="fas fa-cube"></i>
            </div>
            <div class="stat-content">
                <div class="stat-number">{{ $total_solids }}</div>
                <div class="stat-label">Product Solid</div>
            </div>
        </div>
    </div>
    
    <div class="col-xl-3 col-md-6">
        <div class="stat-card" style="background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);">
            <div class="stat-icon">
                <i class="fas fa-paint-brush"></i>
            </div>
            <div class="stat-content">
                <div class="stat-number">{{ $total_veneers }}</div>
                <div class="stat-label">Product Veneer</div>
            </div>
        </div>
    </div>
</div>

<!-- Recent Invoices -->
<div class="row mt-4">
    <div class="col-12">
        <div class="card modern-card">
            <div class="card-header">
                <h5><i class="fas fa-clock"></i> Invoice Terbaru</h5>
            </div>
            <div class="card-body">
                @if($recent_invoices->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Product Name</th>
                                <th>Product Type</th>
                                <th>Product Code</th>
                                <th>Tanggal</th>
                                <th>Grand Total</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($recent_invoices as $invoice)
                            <tr>
                                <td><strong>{{ $invoice->product_name }}</strong></td>
                                <td>{{ $invoice->product_type }}</td>
                                <td><span class="badge bg-secondary">{{ $invoice->product_code }}</span></td>
                                <td>{{ $invoice->invoice_date->format('d M Y') }}</td>
                                <td><strong class="text-success">{{ \App\Helpers\CasegoodHelper::formatRupiah($invoice->grand_total) }}</strong></td>
                                <td>
                                    @if($invoice->is_fixed)
                                        <span class="badge bg-success">Fixed</span>
                                    @else
                                        <span class="badge bg-warning">Draft</span>
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                @else
                <div class="text-center py-5">
                    <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                    <p class="text-muted">Belum ada invoice dibuat</p>
                    <a href="{{ route('invoice.bom.create') }}" class="btn btn-primary mt-2">
                        <i class="fas fa-plus"></i> Buat Invoice Pertama
                    </a>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>

<style>
.stat-card {
    border-radius: 15px;
    padding: 25px;
    color: #fff;
    box-shadow: 0 10px 30px rgba(0,0,0,0.1);
    display: flex;
    align-items: center;
    gap: 20px;
    transition: transform 0.3s ease;
}

.stat-card:hover {
    transform: translateY(-5px);
}

.stat-icon {
    font-size: 50px;
    opacity: 0.3;
}

.stat-content {
    flex: 1;
}

.stat-number {
    font-size: 36px;
    font-weight: 700;
    line-height: 1;
    margin-bottom: 5px;
}

.stat-label {
    font-size: 14px;
    opacity: 0.9;
    font-weight: 500;
}

.modern-card {
    border: none;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
}

.modern-card .card-header {
    background: #fff;
    border-bottom: 2px solid #f0f0f0;
    padding: 20px 25px;
    border-radius: 15px 15px 0 0;
}

.modern-card .card-header h5 {
    margin: 0;
    font-weight: 700;
    color: #2c3e50;
}

.modern-card .card-body {
    padding: 25px;
}

.table thead th {
    background: #f8f9fa;
    font-weight: 600;
    color: #2c3e50;
    border: none;
    padding: 15px;
}

.table tbody tr {
    transition: all 0.2s ease;
}

.table tbody tr:hover {
    background: #f8f9fa;
}

.table tbody td {
    padding: 15px;
    vertical-align: middle;
}
</style>
@endsection