@extends('layouts.app')

@section('title', 'Invoice BOM - Cost Furniture')

@section('page-title', 'Invoice BOM')

@section('content')

<div class="invoice-container">
    <!-- Header Section -->
    <div class="invoice-header">
        <div class="header-content">
            <div>
                <h2 class="invoice-title">Daftar Invoice BOM</h2>
                <p class="invoice-subtitle">Bill of Materials untuk produk furniture</p>
            </div>
            <div class="header-actions">
                <a href="{{ route('invoice.bom.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Buat Invoice BOM
                </a>
            </div>
        </div>
    </div>

    <!-- Filter Section -->
    <div class="filter-section">
        <div class="row g-3">
            <div class="col-md-3">
                <input type="text" 
                       class="form-control" 
                       id="searchInput" 
                       placeholder="Cari product name atau code...">
            </div>
            <div class="col-md-2">
                <select class="form-select" id="filterType">
                    <option value="">Semua Type</option>
                    <option value="Casegoods">Casegoods</option>
                    <option value="Upholstery">Upholstery</option>
                </select>
            </div>
            <div class="col-md-2">
                <select class="form-select" id="filterStatus">
                    <option value="">Semua Status</option>
                    <option value="draft">Draft</option>
                    <option value="fixed">Fixed</option>
                </select>
            </div>
            <div class="col-md-2">
                <button class="btn btn-secondary w-100" onclick="resetFilters()">
                    <i class="fas fa-redo me-2"></i>Reset
                </button>
            </div>
        </div>
    </div>

    <!-- Table Section -->
    <div class="table-section">
        <table class="invoice-table" id="invoiceTable">
            <thead>
                <tr>
                    <th width="5%">ID</th>
                    <th width="15%">Product Name</th>
                    <th width="10%">Product Code</th>
                    <th width="10%">Type</th>
                    <th width="8%">Category</th>
                    <th width="12%">Grand Total</th>
                    <th width="8%">Status</th>
                    <th width="10%">Created At</th>
                    <th width="15%">Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse($invoices as $invoice)
                <tr>
                    <td class="text-center">{{ $invoice->id }}</td>
                    <td>
                        <div class="product-name">{{ $invoice->product_name }}</div>
                    </td>
                    <td>
                        <span class="badge bg-secondary">{{ $invoice->product_code }}</span>
                    </td>
                    <td>
                        <span class="badge bg-info">{{ $invoice->product_type }}</span>
                    </td>
                    <td>{{ $invoice->product_category }}</td>
                    <td class="text-end">
                        <strong class="text-success">{{ \App\Helpers\CasegoodHelper::formatRupiah($invoice->grand_total) }}</strong>
                    </td>
                    <td>
                        @if($invoice->is_fixed)
                            <span class="badge bg-success">
                                <i class="fas fa-check-circle me-1"></i>Fixed
                            </span>
                        @else
                            <span class="badge bg-warning">
                                <i class="fas fa-clock me-1"></i>Draft
                            </span>
                        @endif
                    </td>
                    <td>{{ $invoice->created_at->format('d M Y') }}</td>
                    <td>
                        <div class="action-buttons">
                            <a href="{{ route('invoice.bom.show', $invoice->id) }}" 
                               class="btn btn-sm btn-info" 
                               title="Detail">
                                <i class="fas fa-eye"></i>
                            </a>
                            
                            @if(!$invoice->is_fixed)
                            <a href="{{ route('invoice.bom.edit', $invoice->id) }}" 
                               class="btn btn-sm btn-warning" 
                               title="Edit">
                                <i class="fas fa-edit"></i>
                            </a>
                            @endif
                            
                            <button onclick="deleteInvoice({{ $invoice->id }})" 
                                    class="btn btn-sm btn-danger" 
                                    title="Delete">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="9" class="text-center py-4">
                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                        <p class="text-muted">Belum ada Invoice BOM. Klik tombol "Buat Invoice BOM" untuk memulai.</p>
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    <!-- Pagination -->
    <div class="pagination-section">
        {{ $invoices->links() }}
    </div>
</div>

<style>
/* KEEP ALL YOUR EXISTING STYLES HERE */
.invoice-container {
    max-width: 1400px;
    margin: 0 auto;
    padding: 20px;
}

.invoice-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 15px;
    padding: 30px;
    margin-bottom: 30px;
    box-shadow: 0 10px 30px rgba(102, 126, 234, 0.3);
}

.header-content {
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.invoice-title {
    color: white;
    font-size: 28px;
    font-weight: 700;
    margin: 0;
}

.invoice-subtitle {
    color: rgba(255, 255, 255, 0.9);
    margin: 5px 0 0 0;
    font-size: 14px;
}

.btn-primary {
    background: white;
    color: #667eea;
    border: none;
    padding: 12px 24px;
    border-radius: 10px;
    font-weight: 700;
    transition: all 0.3s ease;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 20px rgba(255, 255, 255, 0.3);
}

.filter-section {
    background: white;
    padding: 20px;
    border-radius: 15px;
    margin-bottom: 20px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
}

.table-section {
    background: white;
    border-radius: 15px;
    overflow: hidden;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
}

.invoice-table {
    width: 100%;
    border-collapse: collapse;
}

.invoice-table thead {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.invoice-table thead th {
    color: white;
    padding: 15px;
    font-weight: 700;
    text-align: left;
}

.invoice-table tbody td {
    padding: 15px;
    border-bottom: 1px solid #f0f0f0;
}

.invoice-table tbody tr:hover {
    background: #f8f9fa;
}

.action-buttons {
    display: flex;
    gap: 5px;
}

.btn-sm {
    padding: 6px 12px;
    border-radius: 6px;
    border: none;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-info {
    background: #17a2b8;
    color: white;
}

.btn-warning {
    background: #ffc107;
    color: white;
}

.btn-danger {
    background: #dc3545;
    color: white;
}

.btn-sm:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}

.badge {
    padding: 5px 10px;
    border-radius: 5px;
    font-size: 12px;
    font-weight: 600;
}

.pagination-section {
    margin-top: 20px;
    display: flex;
    justify-content: center;
}
</style>

<script>
function deleteInvoice(id) {
    if (confirm('Yakin ingin menghapus Invoice BOM ini?')) {
        fetch(`/invoice/bom/${id}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('✅ Invoice BOM berhasil dihapus!');
                location.reload();
            } else {
                alert('❌ Gagal menghapus: ' + data.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('❌ Terjadi kesalahan!');
        });
    }
}

function resetFilters() {
    document.getElementById('searchInput').value = '';
    document.getElementById('filterType').value = '';
    document.getElementById('filterStatus').value = '';
    location.reload();
}

// Search functionality
document.getElementById('searchInput').addEventListener('keyup', function() {
    const searchTerm = this.value.toLowerCase();
    const rows = document.querySelectorAll('#invoiceTable tbody tr');
    
    rows.forEach(row => {
        const text = row.textContent.toLowerCase();
        row.style.display = text.includes(searchTerm) ? '' : 'none';
    });
});
</script>

@endsection