<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Print Invoice Box - {{ $invoiceBox->invoiceBom->product_code }}</title>
    <style>
        @page {
            size: A4 landscape;
            margin: 10mm;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: Arial, sans-serif;
            font-size: 10px;
            line-height: 1.3;
            padding: 15px;
        }
        
        .no-print {
            margin-bottom: 15px;
            text-align: center;
        }
        
        .no-print button {
            padding: 10px 25px;
            margin: 0 5px;
            cursor: pointer;
            border: none;
            border-radius: 5px;
            font-weight: bold;
            font-size: 13px;
        }
        
        .btn-print {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        
        .btn-close {
            background: #e74c3c;
            color: white;
        }
        
        h2, h3 {
            text-align: center;
            margin-bottom: 10px;
        }
        
        .info-section {
            margin-bottom: 15px;
            padding: 10px;
            background: #f8f9fa;
            border-radius: 5px;
        }
        
        .info-section strong {
            display: inline-block;
            width: 150px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        
        th, td {
            border: 1px solid #000;
            padding: 6px;
            text-align: center;
            vertical-align: middle;
        }
        
        th {
            background-color: #f0f0f0;
            font-weight: bold;
            font-size: 9px;
        }
        
        td {
            font-size: 9px;
        }
        
        .text-left {
            text-align: left;
        }
        
        .text-right {
            text-align: right;
        }
        
        .bg-yellow {
            background-color: #fff9e6;
        }
        
        .bg-success {
            background-color: #d4edda;
        }
        
        .bg-info {
            background-color: #d1ecf1;
        }
        
        .bg-warning {
            background-color: #fff3cd;
        }
        
        .bg-skid {
            background-color: #e3f2fd !important;
            font-weight: bold;
        }
        
        .total-row {
            background-color: #fff9e6;
            font-weight: bold;
            font-size: 11px;
        }
        
        .grand-total {
            background: linear-gradient(135deg, #f39c12 0%, #e67e22 100%);
            color: white;
            font-weight: bold;
            font-size: 12px;
            padding: 15px;
            text-align: center;
            margin-top: 20px;
            border-radius: 8px;
        }
        
        @media print {
            .no-print {
                display: none;
            }
            
            body {
                padding: 0;
            }
        }
    </style>
</head>
<body>
    <!-- Print Buttons -->
    <div class="no-print">
        <button class="btn-print" onclick="window.print()">🖨️ Print Invoice</button>
        <button class="btn-close" onclick="window.close()">❌ Close</button>
    </div>

    <!-- Header -->
    <h2>INVOICE BOX PACKING</h2>
    <h3>{{ $invoiceBox->invoiceBom->product_name }} - {{ $invoiceBox->invoiceBom->product_code }}</h3>

    <!-- Info Section -->
    <div class="info-section">
        <div><strong>Product Type:</strong> {{ $invoiceBox->invoiceBom->product_type }}</div>
        <div><strong>Product Category:</strong> {{ $invoiceBox->invoiceBom->product_category }}</div>
        <div><strong>Dimensi Produk:</strong> {{ $invoiceBox->p }}×{{ $invoiceBox->l }}×{{ $invoiceBox->t }} mm</div>
        <div><strong>Tanggal:</strong> {{ $invoiceBox->created_at->format('d M Y H:i') }}</div>
    </div>

    @php
        $boxData = json_decode($invoiceBox->box_data, true);
        $components = $boxData['components'] ?? [];
        $komponenPendukung = $boxData['komponen_pendukung'] ?? [];
        $penunjang = $boxData['penunjang'] ?? null;
        $pallet = $boxData['pallet'] ?? null;
        
        // ✅ SEPARATE SKID FROM KOMPONEN PENDUKUNG
        $skidItems = [];
        $regularKomponenPendukung = [];
        
        foreach ($komponenPendukung as $item) {
            if (isset($item['is_skid']) && $item['is_skid'] === true) {
                $skidItems[] = $item;
            } else {
                $regularKomponenPendukung[] = $item;
            }
        }
        
        // Calculate totals
        $totalComponents = array_sum(array_column($components, 'harga'));
        $totalKomponenPendukung = array_sum(array_column($regularKomponenPendukung, 'total'));
        $totalSkid = array_sum(array_column($skidItems, 'total'));
        $totalPenunjang = ($penunjang && isset($penunjang['enabled']) && $penunjang['enabled']) ? $penunjang['total'] : 0;
        $totalPallet = ($pallet && isset($pallet['enabled']) && $pallet['enabled']) ? $pallet['total'] : 0;
    @endphp

    <!-- Komponen Box Table -->
    <h3 style="text-align: left; margin-top: 20px; margin-bottom: 10px;">📦 KOMPONEN BOX</h3>
    <table>
        <thead>
            <tr>
                <th width="4%">No</th>
                <th width="15%">Jenis Box</th>
                <th width="12%">Dimensi Box<br>(PJG×LBR×TGI)</th>
                <th width="12%">Ukuran Karton<br>(PJG×LBR)</th>
                <th width="8%">M²</th>
                <th width="10%">Price/M²</th>
                <th width="10%">Price Karton</th>
                <th width="8%">Qty</th>
                <th width="12%">Harga</th>
            </tr>
        </thead>
        <tbody>
            @forelse($components as $index => $component)
            <tr>
                <td>{{ $index + 1 }}</td>
                <td class="text-left"><strong>{{ $component['jenis_box'] }}</strong></td>
                <td>{{ $component['dimensi_box']['pjg'] }}×{{ $component['dimensi_box']['lbr'] }}×{{ $component['dimensi_box']['tgi'] }}</td>
                <td>{{ $component['ukuran_karton']['pjg'] }}×{{ $component['ukuran_karton']['lbr'] }}</td>
                <td>{{ number_format($component['ukuran_karton']['m2'], 6) }}</td>
                <td class="text-right">Rp {{ number_format($component['price_m2'], 0, ',', '.') }}</td>
                <td class="text-right">Rp {{ number_format($component['price_karton'], 0, ',', '.') }}</td>
                <td>{{ $component['kebutuhan_unit'] }}</td>
                <td class="text-right"><strong>Rp {{ number_format($component['harga'], 0, ',', '.') }}</strong></td>
            </tr>
            @empty
            <tr>
                <td colspan="9" class="text-center">Tidak ada komponen box</td>
            </tr>
            @endforelse
        </tbody>
        <tfoot>
            <tr class="total-row bg-yellow">
                <td colspan="8" class="text-right"><strong>SUBTOTAL KOMPONEN BOX:</strong></td>
                <td class="text-right"><strong>Rp {{ number_format($totalComponents, 0, ',', '.') }}</strong></td>
            </tr>
        </tfoot>
    </table>

    <!-- Komponen Pendukung Table -->
    @if(count($regularKomponenPendukung) > 0 || count($skidItems) > 0 || $totalPenunjang > 0 || $totalPallet > 0)
    <h3 style="text-align: left; margin-top: 20px; margin-bottom: 10px;">📦 KOMPONEN PENDUKUNG</h3>
    <table>
        <thead>
            <tr>
                <th width="4%">No</th>
                <th width="12%">Kode Barang</th>
                <th width="20%">Nama</th>
                <th width="8%">Tipe</th>
                <!-- ✅ SEPARATE DIMENSION COLUMNS FOR SKID -->
                <th width="8%">PJG<br>(mm)</th>
                <th width="8%">LBR<br>(mm)</th>
                <th width="8%">TGI<br>(mm)</th>
                <th width="8%">M²</th>
                <th width="6%">Qty</th>
                <th width="10%">Harga</th>
                <th width="12%">Total</th>
            </tr>
        </thead>
        <tbody>
            @php $kpNo = 1; @endphp
            
            <!-- Regular Komponen Pendukung Items -->
            @foreach($regularKomponenPendukung as $item)
            <tr>
                <td>{{ $kpNo++ }}</td>
                <td>{{ $item['material_code'] }}</td>
                <td class="text-left">{{ $item['nama'] }}</td>
                <td>
                    @if($item['pricing_type'] === 'pcs')
                        <span style="background: #28a745; color: white; padding: 2px 6px; border-radius: 3px; font-size: 8px;">PCS</span>
                    @else
                        <span style="background: #17a2b8; color: white; padding: 2px 6px; border-radius: 3px; font-size: 8px;">M2</span>
                    @endif
                </td>
                <!-- ✅ SEPARATE DIMENSION COLUMNS -->
                <td>{{ $item['pjg'] > 0 ? $item['pjg'] : '-' }}</td>
                <td>{{ $item['lbr'] > 0 ? $item['lbr'] : '-' }}</td>
                <td>{{ $item['tgi'] > 0 ? $item['tgi'] : '-' }}</td>
                <td>
                    @if($item['pricing_type'] === 'm2' && isset($item['m2']))
                        {{ number_format($item['m2'], 4) }}
                    @else
                        -
                    @endif
                </td>
                <td>{{ $item['qty'] }}</td>
                <td class="text-right">Rp {{ number_format($item['harga_finished'], 0, ',', '.') }}</td>
                <td class="text-right"><strong>Rp {{ number_format($item['total'], 0, ',', '.') }}</strong></td>
            </tr>
            @endforeach
            
            <!-- ✅ SKID ITEMS (WITH SEPARATE DIMENSION COLUMNS) -->
            @foreach($skidItems as $skid)
            <tr class="bg-skid">
                <td>{{ $kpNo++ }}</td>
                <td><strong>{{ $skid['material_code'] }}</strong></td>
                <td class="text-left"><strong>{{ $skid['nama'] }}</strong></td>
                <td>
                    <span style="background: #2196F3; color: white; padding: 2px 6px; border-radius: 3px; font-size: 8px;">M2</span>
                </td>
                <!-- ✅ SEPARATE DIMENSION COLUMNS FOR SKID -->
                <td><strong>{{ $skid['pjg'] }}</strong></td>
                <td><strong>{{ $skid['lbr'] }}</strong></td>
                <td><strong>{{ $skid['tgi'] }}</strong></td>
                <td><strong>{{ number_format($skid['m2'], 6) }}</strong></td>
                <td><strong>{{ $skid['qty'] }}</strong></td>
                <td class="text-right"><strong>Rp {{ number_format($skid['harga_finished'], 0, ',', '.') }}</strong></td>
                <td class="text-right"><strong>Rp {{ number_format($skid['total'], 0, ',', '.') }}</strong></td>
            </tr>
            @endforeach
            
            <!-- Penunjang (if enabled) -->
            @if($totalPenunjang > 0)
            <tr class="bg-warning">
                <td>{{ $kpNo++ }}</td>
                <td>-</td>
                <td class="text-left"><strong>Penunjang ({{ $penunjang['category'] }})</strong></td>
                <td>
                    <span style="background: #ffc107; color: #000; padding: 2px 6px; border-radius: 3px; font-size: 8px;">PCS</span>
                </td>
                <td>-</td>
                <td>-</td>
                <td>-</td>
                <td>-</td>
                <td>{{ $penunjang['qty'] }}</td>
                <td class="text-right">Rp {{ number_format($penunjang['harga'], 0, ',', '.') }}</td>
                <td class="text-right"><strong>Rp {{ number_format($penunjang['total'], 0, ',', '.') }}</strong></td>
            </tr>
            @endif
            
            <!-- Pallet (if enabled) -->
            @if($totalPallet > 0)
            <tr class="bg-info">
                <td>{{ $kpNo++ }}</td>
                <td>-</td>
                <td class="text-left"><strong>Pallet</strong></td>
                <td>
                    <span style="background: #17a2b8; color: white; padding: 2px 6px; border-radius: 3px; font-size: 8px;">PCS</span>
                </td>
                <td>-</td>
                <td>-</td>
                <td>-</td>
                <td>-</td>
                <td>{{ $pallet['qty'] }}</td>
                <td class="text-right">Rp {{ number_format($pallet['harga'], 0, ',', '.') }}</td>
                <td class="text-right"><strong>Rp {{ number_format($pallet['total'], 0, ',', '.') }}</strong></td>
            </tr>
            @endif
        </tbody>
        <tfoot>
            <tr class="total-row bg-success">
                <td colspan="10" class="text-right"><strong>SUBTOTAL KOMPONEN PENDUKUNG:</strong></td>
                <td class="text-right"><strong>Rp {{ number_format($totalKomponenPendukung + $totalSkid + $totalPenunjang + $totalPallet, 0, ',', '.') }}</strong></td>
            </tr>
        </tfoot>
    </table>
    @endif

    <!-- Grand Total -->
    <div class="grand-total">
        <div style="display: flex; justify-content: space-between; align-items: center;">
            <div style="text-align: left;">
                <div style="font-size: 16px; margin-bottom: 5px;">GRAND TOTAL BOX PACKING</div>
                <div style="font-size: 11px; opacity: 0.9;">
                    Komponen Box: Rp {{ number_format($totalComponents, 0, ',', '.') }}
                    @if($totalKomponenPendukung > 0)
                        | KP: Rp {{ number_format($totalKomponenPendukung, 0, ',', '.') }}
                    @endif
                    @if($totalSkid > 0)
                        | SKID: Rp {{ number_format($totalSkid, 0, ',', '.') }}
                    @endif
                    @if($totalPenunjang > 0)
                        | Penunjang: Rp {{ number_format($totalPenunjang, 0, ',', '.') }}
                    @endif
                    @if($totalPallet > 0)
                        | Pallet: Rp {{ number_format($totalPallet, 0, ',', '.') }}
                    @endif
                </div>
            </div>
            <div style="text-align: right; font-size: 20px;">
                Rp {{ number_format($invoiceBox->grand_total, 0, ',', '.') }}
            </div>
        </div>
    </div>

    <script>
        console.log('============================================');
        console.log('📦 INVOICE BOX PRINT');
        console.log('============================================');
        console.log('Invoice Box ID:', {{ $invoiceBox->id }});
        console.log('Product:', '{{ $invoiceBox->invoiceBom->product_name }}');
        console.log('');
        console.log('--- COMPONENTS ---');
        console.log('Total Components:', {{ $totalComponents }});
        console.log('');
        console.log('--- KOMPONEN PENDUKUNG ---');
        console.log('Regular KP Total:', {{ $totalKomponenPendukung }});
        console.log('SKID Total:', {{ $totalSkid }});
        console.log('Penunjang Total:', {{ $totalPenunjang }});
        console.log('Pallet Total:', {{ $totalPallet }});
        console.log('');
        console.log('--- GRAND TOTAL ---');
        console.log('Grand Total:', {{ $invoiceBox->grand_total }});
        console.log('============================================');
    </script>
</body>
</html>