@extends('layouts.app')

@section('title', 'Invoice Fitting - Cost Furniture')

@section('page-title', 'Invoice Fitting')

@section('content')
<div class="card modern-card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5><i class="fas fa-cog"></i> Daftar Invoice Fitting</h5>
        <a href="{{ route('invoice.fitting.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Buat Invoice Fitting Baru
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th width="5%">No</th>
                        <th>Invoice BOM</th>
                        <th>Product Name</th>
                        <th>Product Code</th>
                        <th>Category</th>
                        <th>Total Fitting</th>
                        <th>Tanggal Dibuat</th>
                        <th width="20%">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($invoiceFittings as $index => $invoiceFitting)
                    <tr>
                        <td>{{ $invoiceFittings->firstItem() + $index }}</td>
                        <td>
                            <a href="{{ route('invoice.bom.show', $invoiceFitting->invoiceBom->id) }}" 
                               class="text-primary" 
                               title="Lihat Invoice BOM">
                                <i class="fas fa-link"></i> BOM #{{ $invoiceFitting->invoiceBom->id }}
                            </a>
                        </td>
                        <td><strong>{{ $invoiceFitting->invoiceBom->product_name }}</strong></td>
                        <td><span class="badge bg-secondary">{{ $invoiceFitting->invoiceBom->product_code }}</span></td>
                        <td><span class="badge bg-info">{{ $invoiceFitting->invoiceBom->product_category }}</span></td>
                        <td><strong class="text-success">{{ \App\Helpers\CasegoodHelper::formatRupiah($invoiceFitting->grand_total) }}</strong></td>
                        <td>{{ $invoiceFitting->created_at->format('d M Y H:i') }}</td>
                        <td>
                            <div class="btn-group" role="group">
                                <a href="{{ route('invoice.fitting.show', $invoiceFitting->id) }}" 
                                   class="btn btn-sm btn-info" 
                                   title="Lihat Detail">
                                    <i class="fas fa-eye"></i>
                                </a>
                                
                                <a href="{{ route('invoice.fitting.edit', $invoiceFitting->id) }}" 
                                   class="btn btn-sm btn-warning" 
                                   title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                
                                <form action="{{ route('invoice.fitting.destroy', $invoiceFitting->id) }}" 
                                      method="POST" 
                                      class="d-inline" 
                                      onsubmit="return confirm('Yakin ingin menghapus invoice fitting ini?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" 
                                            class="btn btn-sm btn-danger" 
                                            title="Hapus">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center py-5">
                            <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                            <p class="text-muted">Belum ada invoice fitting</p>
                            <a href="{{ route('invoice.fitting.create') }}" class="btn btn-primary mt-2">
                                <i class="fas fa-plus"></i> Buat Invoice Fitting Pertama
                            </a>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($invoiceFittings->hasPages())
        <div class="mt-4">
            {{ $invoiceFittings->links() }}
        </div>
        @endif
    </div>
</div>

<style>
.modern-card {
    border: none;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
}

.modern-card .card-header {
    background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
    color: white;
    border-radius: 15px 15px 0 0;
    padding: 20px 25px;
    border: none;
}

.modern-card .card-header h5 {
    margin: 0;
    font-weight: 700;
    color: white;
}

.modern-card .card-body {
    padding: 25px;
}

.table thead th {
    background: #f8f9fa;
    font-weight: 600;
    color: #2c3e50;
    border: none;
    padding: 15px;
    font-size: 13px;
}

.table tbody tr {
    transition: all 0.2s ease;
}

.table tbody tr:hover {
    background: #f8f9fa;
}

.table tbody td {
    padding: 15px;
    vertical-align: middle;
    font-size: 13px;
}

.btn-sm {
    padding: 5px 10px;
    font-size: 12px;
    margin: 2px;
}

.btn-group {
    display: flex;
    flex-wrap: wrap;
    gap: 3px;
}

.btn-group .btn-sm {
    flex: 0 0 auto;
}

/* Button Colors */
.btn-info {
    background-color: #17a2b8;
    border-color: #17a2b8;
    color: white;
}

.btn-info:hover {
    background-color: #138496;
    border-color: #117a8b;
}

.btn-warning {
    background-color: #ffc107;
    border-color: #ffc107;
    color: #000;
}

.btn-warning:hover {
    background-color: #e0a800;
    border-color: #d39e00;
}

.btn-danger {
    background-color: #dc3545;
    border-color: #dc3545;
}

.btn-danger:hover {
    background-color: #c82333;
    border-color: #bd2130;
}

.btn-primary {
    background: linear-gradient(135deg, #3498db 0%, #2980b9 100%);
    border: none;
}

.btn-primary:hover {
    background: linear-gradient(135deg, #2980b9 0%, #21618c 100%);
}
</style>
@endsection
