@extends('layouts.app')

@section('title', ($solid ? 'Edit' : 'Tambah') . ' Product Solid - Cost Furniture')

@section('page-title', ($solid ? 'Edit' : 'Tambah') . ' Product Solid')

@section('content')
<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card modern-card">
            <div class="card-header">
                <h5>
                    <i class="fas fa-{{ $solid ? 'edit' : 'plus-circle' }}"></i> 
                    {{ $solid ? 'Edit' : 'Tambah' }} Product Solid
                </h5>
            </div>
            <div class="card-body">
                <form action="{{ $solid ? route('product.solid.update', $solid->id) : route('product.solid.store') }}" method="POST">
                    @csrf
                    @if($solid)
                        @method('PUT')
                    @endif
                    
                    <div class="mb-3">
                        <label class="form-label">Solid Type <span class="text-danger">*</span></label>
                        <select name="solid_type" class="form-select @error('solid_type') is-invalid @enderror" required>
                            <option value="">-- Pilih Solid Type --</option>
                            <option value="MAHONI" {{ old('solid_type', $solid->solid_type ?? '') == 'MAHONI' ? 'selected' : '' }}>MAHONI</option>
                            <option value="WALNUT" {{ old('solid_type', $solid->solid_type ?? '') == 'WALNUT' ? 'selected' : '' }}>WALNUT</option>
                            <option value="WHITE OAK" {{ old('solid_type', $solid->solid_type ?? '') == 'WHITE OAK' ? 'selected' : '' }}>WHITE OAK</option>
                            <option value="WHITE ASH / BEECH" {{ old('solid_type', $solid->solid_type ?? '') == 'WHITE ASH / BEECH' ? 'selected' : '' }}>WHITE ASH / BEECH</option>
                            <option value="MAPLE" {{ old('solid_type', $solid->solid_type ?? '') == 'MAPLE' ? 'selected' : '' }}>MAPLE</option>
                            <option value="JATI" {{ old('solid_type', $solid->solid_type ?? '') == 'JATI' ? 'selected' : '' }}>JATI</option>
                        </select>
                        @error('solid_type')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Thickness (mm) <span class="text-danger">*</span></label>
                        <input type="number" 
                               name="thickness" 
                               class="form-control @error('thickness') is-invalid @enderror" 
                               value="{{ old('thickness', $solid->thickness ?? '') }}"
                               step="0.01"
                               placeholder="Contoh: 18"
                               required>
                        @error('thickness')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Price (per M2) <span class="text-danger">*</span></label>
                        <input type="number" 
                               name="price" 
                               class="form-control @error('price') is-invalid @enderror" 
                               value="{{ old('price', $solid->price ?? '') }}"
                               step="0.01"
                               placeholder="Contoh: 264000"
                               required>
                        @error('price')
                        <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="text-muted">Harga dalam Rupiah per meter persegi</small>
                    </div>
                    
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> {{ $solid ? 'Update' : 'Simpan' }}
                        </button>
                        <a href="{{ route('product.solid.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
.modern-card {
    border: none;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
}

.modern-card .card-header {
    background: #fff;
    border-bottom: 2px solid #f0f0f0;
    padding: 20px 25px;
    border-radius: 15px 15px 0 0;
}

.modern-card .card-header h5 {
    margin: 0;
    font-weight: 700;
    color: #2c3e50;
}

.modern-card .card-body {
    padding: 25px;
}

.form-label {
    font-weight: 600;
    color: #2c3e50;
    margin-bottom: 8px;
    font-size: 14px;
}

.form-control, .form-select {
    padding: 12px 15px;
    border: 2px solid #e0e0e0;
    border-radius: 10px;
    font-size: 14px;
    transition: all 0.3s ease;
}

.form-control:focus, .form-select:focus {
    border-color: #667eea;
    box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.1);
}
</style>
@endsection