@extends('layouts.app')

@section('title', 'Product Solid - Cost Furniture')

@section('page-title', 'Product Solid')

@section('content')
<div class="card modern-card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5><i class="fas fa-cube"></i> Data Product Solid</h5>
        <a href="{{ route('product.solid.create') }}" class="btn btn-primary">
            <i class="fas fa-plus"></i> Tambah Solid
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover" id="solidTable">
                <thead>
                    <tr>
                        <th width="5%">No</th>
                        <th>Solid Type</th>
                        <th>Thickness (mm)</th>
                        <th>Price (per M2)</th>
                        <th width="15%">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($solids as $index => $solid)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>
                            <span class="badge bg-primary">{{ $solid->solid_type }}</span>
                        </td>
                        <td>{{ number_format($solid->thickness, 2) }} mm</td>
                        <td><strong class="text-success">{{ \App\Helpers\CasegoodHelper::formatRupiah($solid->price) }}</strong></td>
                        <td>
                            <a href="{{ route('product.solid.edit', $solid->id) }}" class="btn btn-sm btn-warning">
                                <i class="fas fa-edit"></i> Edit
                            </a>
                            <form action="{{ route('product.solid.destroy', $solid->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Yakin ingin menghapus data ini?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="fas fa-trash"></i> Hapus
                                </button>
                            </form>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="text-center py-4">
                            <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                            <p class="text-muted">Belum ada data solid</p>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

<style>
.modern-card {
    border: none;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
}

.modern-card .card-header {
    background: #fff;
    border-bottom: 2px solid #f0f0f0;
    padding: 20px 25px;
    border-radius: 15px 15px 0 0;
}

.modern-card .card-header h5 {
    margin: 0;
    font-weight: 700;
    color: #2c3e50;
}

.modern-card .card-body {
    padding: 25px;
}

.table thead th {
    background: #f8f9fa;
    font-weight: 600;
    color: #2c3e50;
    border: none;
    padding: 15px;
}

.table tbody tr {
    transition: all 0.2s ease;
}

.table tbody tr:hover {
    background: #f8f9fa;
}

.table tbody td {
    padding: 15px;
    vertical-align: middle;
}

.btn-sm {
    padding: 5px 12px;
    font-size: 12px;
}
</style>
@endsection