

<?php $__env->startSection('title', 'Detail Invoice BOM - Cost Furniture'); ?>

<?php $__env->startSection('page-title', 'Detail Invoice BOM'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <!-- Action Buttons -->
        <div class="mb-3 d-flex justify-content-between align-items-center">
            <a href="<?php echo e(route('invoice.bom.index')); ?>" class="btn btn-secondary">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
            <div class="d-flex gap-2">
                <?php if(!$invoice->is_fixed): ?>
                <a href="<?php echo e(route('invoice.bom.edit', $invoice->id)); ?>" class="btn btn-warning">
                    <i class="fas fa-edit"></i> Edit Invoice
                </a>
                <form action="<?php echo e(route('invoice.bom.fix', $invoice->id)); ?>" method="POST" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-success" onclick="return confirm('Fix invoice ini? Invoice yang sudah di-fix tidak bisa diedit lagi.')">
                        <i class="fas fa-lock"></i> Fix Invoice
                    </button>
                </form>
                <?php else: ?>
                <form action="<?php echo e(route('invoice.bom.unfix', $invoice->id)); ?>" method="POST" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-warning" onclick="return confirm('Unfix invoice ini? Invoice bisa diedit kembali.')">
                        <i class="fas fa-unlock"></i> Unfix Invoice
                    </button>
                </form>
                <?php endif; ?>
                <a href="<?php echo e(route('invoice.bom.print', $invoice->id)); ?>" class="btn btn-primary" target="_blank">
                    <i class="fas fa-print"></i> Print Invoice
                </a>
                <a href="<?php echo e(route('invoice.bom.print.hpp', $invoice->id)); ?>" class="btn btn-success" target="_blank">
                    <i class="fas fa-file-invoice-dollar"></i> Print HPP
                </a>
                <form action="<?php echo e(route('invoice.bom.destroy', $invoice->id)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Yakin ingin menghapus invoice ini?')">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger">
                        <i class="fas fa-trash"></i> Hapus
                    </button>
                </form>
            </div>
        </div>

        <!-- Invoice Detail Card -->
        <div class="card modern-card">
            <div class="card-header">
                <div class="row">
                    <div class="col-md-8">
                        <h4 class="mb-0"><i class="fas fa-file-invoice"></i> <?php echo e($invoice->product_type); ?></h4>
                        <p class="text-muted mb-0">Invoice Code: <?php echo e($invoice->product_code); ?></p>
                    </div>
                    <div class="col-md-4 text-end">
                        <?php if($invoice->is_fixed): ?>
                            <span class="badge bg-success" style="font-size: 16px;">
                                <i class="fas fa-lock"></i> FIXED
                            </span>
                        <?php else: ?>
                            <span class="badge bg-warning" style="font-size: 16px;">
                                <i class="fas fa-edit"></i> DRAFT
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <!-- Invoice Header Info -->
                <div class="row mb-4">
                    <div class="col-md-8">
                        <div class="invoice-info">
                            <table class="table table-borderless">
                                <tr>
                                    <td width="200"><strong>Product Name (Buyer)</strong></td>
                                    <td>: <?php echo e($invoice->product_name); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Product Category</strong></td>
                                    <td>: <span class="badge bg-info"><?php echo e($invoice->product_category); ?></span></td>
                                </tr>
                                <tr>
                                    <td><strong>Product Type</strong></td>
                                    <td>: <?php echo e($invoice->product_type); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Product Code</strong></td>
                                    <td>: <span class="badge bg-secondary"><?php echo e($invoice->product_code); ?></span></td>
                                </tr>
                                <tr>
                                    <td><strong>Size</strong></td>
                                    <td>: <?php echo e($invoice->size); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Date</strong></td>
                                    <td>: <?php echo e($invoice->invoice_date->format('d F Y')); ?></td>
                                </tr>
                                <tr>
                                    <td><strong>Order</strong></td>
                                    <td>: <?php echo e($invoice->order_qty); ?> Pcs</td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <?php if($invoice->image_path): ?>
                        <div class="product-image">
                            <img src="<?php echo e(asset($invoice->image_path)); ?>" alt="Product Image" class="img-fluid rounded">
                        </div>
                        <?php else: ?>
                        <div class="product-image-placeholder">
                            <i class="fas fa-image fa-3x text-muted"></i>
                            <p class="text-muted">No Image</p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <hr>

                <!-- Material Locking Info -->
                <div class="row mb-4">
                    <div class="col-12">
                        <h6 class="mb-3"><i class="fas fa-lock"></i> Material Locking</h6>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="material-box">
                                    <small class="text-muted">Panel</small>
                                    <div class="fw-bold"><?php echo e($invoice->panel_type ?? '-'); ?></div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="material-box">
                                    <small class="text-muted">Solid</small>
                                    <div class="fw-bold"><?php echo e($invoice->solid_type ?? '-'); ?></div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="material-box">
                                    <small class="text-muted">Veneer Face</small>
                                    <div class="fw-bold"><?php echo e($invoice->veneer_face_type ?? '-'); ?></div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="material-box">
                                    <small class="text-muted">Veneer Back</small>
                                    <div class="fw-bold"><?php echo e($invoice->veneer_back_type ?? '-'); ?></div>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="material-box">
                                    <small class="text-muted">Box Drawer</small>
                                    <div class="fw-bold"><?php echo e($invoice->box_drawer_type ?? '-'); ?></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <hr>

                <!-- ✅ NEW: M³ & Biaya Produksi Section -->
                <div class="row mb-4">
                    <div class="col-12">
                        <h6 class="mb-3"><i class="fas fa-cube"></i> Biaya Produksi (M³)</h6>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="biaya-box">
                                    <small class="text-muted">Total M³</small>
                                    <div class="fw-bold text-primary">
                                        <?php echo e(number_format($invoice->total_m3 ?? 0, 6)); ?> m³
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="biaya-box">
                                    <small class="text-muted">Harga per M³</small>
                                    <div class="fw-bold">
                                        <?php echo e(\App\Helpers\CasegoodHelper::formatRupiah($invoice->harga_per_m3 ?? 6000000)); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="biaya-box">
                                    <small class="text-muted">Biaya Produksi</small>
                                    <div class="fw-bold text-success">
                                        <?php echo e(\App\Helpers\CasegoodHelper::formatRupiah($invoice->biaya_produksi ?? 0)); ?>

                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="biaya-box" style="border-left: 4px solid #28a745; background: #d4edda;">
                                    <small class="text-muted">Final Grand Total</small>
                                    <div class="fw-bold text-success" style="font-size: 18px;">
                                        <?php echo e(\App\Helpers\CasegoodHelper::formatRupiah($invoice->final_grand_total ?? $invoice->grand_total)); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="alert alert-info mt-3">
                            <i class="fas fa-info-circle me-2"></i>
                            <strong>Formula:</strong> Total M³ × Harga per M³ = Biaya Produksi
                        </div>
                    </div>
                </div>

                <hr>

                <!-- ✅ Painting Cost Calculator -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="d-flex justify-content-between align-items-center mb-3">
                            <h6 class="mb-0">
                                <i class="fas fa-paint-brush"></i> Painting Cost Calculator
                            </h6>
                            <button type="button" class="btn btn-sm btn-warning" onclick="openPaintingModal()">
                                <i class="fas fa-dollar-sign"></i> Atur Painting Cost
                            </button>
                        </div>
                        
                        <div id="painting-summary" class="painting-summary-box">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="painting-stat">
                                        <small class="text-muted">Total Material Painting</small>
                                        <h5 class="text-success mb-0" id="total-material-painting">Rp 0</h5>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="painting-stat">
                                        <small class="text-muted">Total Biaya Produksi Painting</small>
                                        <h5 class="text-primary mb-0" id="total-biaya-produksi-painting">Rp 0</h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <hr>

                <!-- Calculation Data -->
                <div class="row">
                    <div class="col-12">
                        <h6 class="mb-3"><i class="fas fa-calculator"></i> Calculation Details</h6>
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th width="5%">No</th>
                                        <th>Component Name</th>
                                        <th>Details</th>
                                        <th width="15%" class="text-end">Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        $calculationData = json_decode($invoice->calculation_data, true);
                                        $no = 1;
                                    ?>
                                    
                                    <?php if($calculationData): ?>
                                        <?php $__currentLoopData = $calculationData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($no++); ?></td>
                                            <td><strong><?php echo e(ucwords(str_replace('-', ' ', $key))); ?></strong></td>
                                            <td>
                                                <?php if(isset($data['details'])): ?>
                                                    <small class="text-muted">
                                                        <?php if(isset($data['details']['width'])): ?>
                                                            Width: <?php echo e($data['details']['width']); ?>mm, 
                                                        <?php endif; ?>
                                                        <?php if(isset($data['details']['length'])): ?>
                                                            Length: <?php echo e($data['details']['length']); ?>mm, 
                                                        <?php endif; ?>
                                                        <?php if(isset($data['details']['qty'])): ?>
                                                            Qty: <?php echo e($data['details']['qty']); ?>

                                                        <?php endif; ?>
                                                        <?php if(isset($data['details']['m2'])): ?>
                                                            | M²: <?php echo e(number_format($data['details']['m2'], 6)); ?>

                                                        <?php endif; ?>
                                                        <?php if(isset($data['m3'])): ?>
                                                            | M³: <?php echo e(number_format($data['m3'], 6)); ?>

                                                        <?php endif; ?>
                                                    </small>
                                                <?php else: ?>
                                                    <small class="text-muted">-</small>
                                                <?php endif; ?>
                                            </td>
                                            <td class="text-end">
                                                <strong class="text-success">
                                                    <?php echo e(\App\Helpers\CasegoodHelper::formatRupiah($data['componentTotal'] ?? 0)); ?>

                                                </strong>
                                            </td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="4" class="text-center">No calculation data available</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                                <tfoot class="table-light">
                                    <tr>
                                        <th colspan="3" class="text-end">TOTAL COMPONENTS:</th>
                                        <th class="text-end">
                                            <h5 class="mb-0 text-primary">
                                                <?php echo e(\App\Helpers\CasegoodHelper::formatRupiah($invoice->grand_total)); ?>

                                            </h5>
                                        </th>
                                    </tr>
                                    <tr>
                                        <th colspan="3" class="text-end">BIAYA PRODUKSI (M³):</th>
                                        <th class="text-end">
                                            <h5 class="mb-0 text-success">
                                                <?php echo e(\App\Helpers\CasegoodHelper::formatRupiah($invoice->biaya_produksi ?? 0)); ?>

                                            </h5>
                                        </th>
                                    </tr>
                                    <tr style="background-color: #d4edda;">
                                        <th colspan="3" class="text-end">FINAL GRAND TOTAL:</th>
                                        <th class="text-end">
                                            <h4 class="mb-0 text-success">
                                                <?php echo e(\App\Helpers\CasegoodHelper::formatRupiah($invoice->final_grand_total ?? $invoice->grand_total)); ?>

                                            </h4>
                                        </th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- ✅ Painting Cost Modal -->
<div class="modal fade" id="paintingModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-warning text-white">
                <h5 class="modal-title">
                    <i class="fas fa-paint-brush me-2"></i>Atur Painting Cost per Component
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i>
                    <strong>Formula:</strong><br>
                    • Material Painting = M² × Sisi × 70.000<br>
                    • Biaya Produksi Painting = M² × Sisi × 50.000
                </div>
                
                <div id="painting-components-list">
                    <!-- Components will be loaded here -->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                <button type="button" class="btn btn-warning" onclick="savePaintingData()">
                    <i class="fas fa-save me-2"></i>Simpan Painting Cost
                </button>
            </div>
        </div>
    </div>
</div>

<style>
.modern-card {
    border: none;
    border-radius: 15px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
}

.modern-card .card-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: #fff;
    border-radius: 15px 15px 0 0;
    padding: 25px;
}

.modern-card .card-body {
    padding: 30px;
}

.invoice-info table td {
    padding: 8px 0;
}

.product-image {
    border: 3px solid #e0e0e0;
    border-radius: 12px;
    overflow: hidden;
    padding: 10px;
    background: #f8f9fa;
}

.product-image img {
    width: 100%;
    height: auto;
    border-radius: 8px;
}

.product-image-placeholder {
    border: 3px dashed #e0e0e0;
    border-radius: 12px;
    padding: 40px;
    text-align: center;
    background: #f8f9fa;
}

.material-box {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 10px;
    border-left: 4px solid #667eea;
}

.material-box small {
    display: block;
    font-size: 11px;
    margin-bottom: 5px;
}

.material-box .fw-bold {
    font-size: 14px;
    color: #2c3e50;
}

/* ✅ NEW: Biaya Produksi Box */
.biaya-box {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 10px;
    border-left: 4px solid #667eea;
    text-align: center;
}

.biaya-box small {
    display: block;
    font-size: 11px;
    margin-bottom: 8px;
    text-transform: uppercase;
}

.biaya-box .fw-bold {
    font-size: 16px;
    color: #2c3e50;
}

/* ✅ Painting Summary Box */
.painting-summary-box {
    background: linear-gradient(135deg, rgba(243, 156, 18, 0.1) 0%, rgba(230, 126, 34, 0.1) 100%);
    border: 2px solid #f39c12;
    border-radius: 10px;
    padding: 20px;
}

.painting-stat {
    text-align: center;
    padding: 15px;
    background: white;
    border-radius: 8px;
}

.painting-stat small {
    display: block;
    font-size: 11px;
    text-transform: uppercase;
    margin-bottom: 8px;
}

/* ✅ Component Card in Modal */
.component-card {
    background: #fff;
    border: 2px solid #e9ecef;
    border-left: 4px solid #f39c12;
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 15px;
}

.component-card .component-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 10px;
    padding-bottom: 10px;
    border-bottom: 2px solid #f0f0f0;
}

.component-card .component-title {
    font-weight: 700;
    color: #2c3e50;
    font-size: 14px;
}

.component-card .m2-badge {
    background: #fff3cd;
    color: #856404;
    padding: 4px 10px;
    border-radius: 5px;
    font-size: 11px;
    font-weight: 600;
}

.component-card input[type="number"] {
    max-width: 100px;
}

.result-box {
    background: #f8f9fa;
    padding: 10px;
    border-radius: 5px;
    margin-top: 10px;
}

.result-box small {
    display: block;
    font-size: 10px;
    color: #666;
    margin-bottom: 3px;
}

.result-box .value {
    font-size: 13px;
    font-weight: 700;
    color: #27ae60;
}

.table-bordered {
    border: 2px solid #e0e0e0;
}

.table thead th {
    font-weight: 700;
    color: #2c3e50;
}
</style>

<script>
// ============================================
// GLOBAL VARIABLES
// ============================================

const invoiceId = <?php echo e($invoice->id); ?>;
const calculationData = <?php echo json_encode(json_decode($invoice->calculation_data, true), 512) ?>;

// ✅ CRITICAL: Use window scope to prevent reset
window.paintingData = {};

console.log('Invoice ID:', invoiceId);
console.log('Calculation Data:', calculationData);

// ============================================
// LOAD PAINTING DATA ON PAGE LOAD
// ============================================

document.addEventListener('DOMContentLoaded', function() {
    console.log('Invoice BOM Show Page Loaded');
    loadPaintingData();
});

// ============================================
// LOAD EXISTING PAINTING DATA
// ============================================

function loadPaintingData() {
    fetch(`/invoice/bom/${invoiceId}/get-painting`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                window.paintingData = data.painting_data || {};
                
                // Update summary display
                const materialTotal = data.total_material_painting || 0;
                const biayaTotal = data.total_biaya_produksi_painting || 0;
                
                document.getElementById('total-material-painting').textContent = formatRupiah(materialTotal);
                document.getElementById('total-biaya-produksi-painting').textContent = formatRupiah(biayaTotal);
                
                console.log('✓ Painting data loaded:', window.paintingData);
                
                // Show/hide summary box based on data
                const summaryBox = document.querySelector('.painting-summary-box');
                if (materialTotal > 0 || biayaTotal > 0) {
                    summaryBox.style.border = '2px solid #28a745';
                } else {
                    summaryBox.style.border = '2px solid #f39c12';
                }
            }
        })
        .catch(error => {
            console.error('Error loading painting data:', error);
        });
}

// ============================================
// OPEN PAINTING MODAL
// ============================================

function openPaintingModal() {
    const componentsList = document.getElementById('painting-components-list');
    componentsList.innerHTML = '';
    
    if (!calculationData) {
        componentsList.innerHTML = '<p class="text-center text-muted">Tidak ada data komponen</p>';
        return;
    }
    
    console.log('[MODAL] Opening modal, current paintingData:', window.paintingData);
    
    // Loop through components
    let componentIndex = 0;
    Object.keys(calculationData).forEach((componentKey) => {
        const component = calculationData[componentKey];
        const componentName = component.componentName || componentKey;
        
        // Calculate total M² for this component
        let totalM2 = 0;
        if (component.subComponents) {
            Object.values(component.subComponents).forEach(sub => {
                totalM2 += parseFloat(sub.m2 || 0);
            });
        }
        
        // Skip if no M² data
        if (totalM2 === 0) {
            return;
        }
        
        // Get existing painting data for this component
        const existingData = window.paintingData[componentName] || {};
        const existingSisi = existingData.sisi || 0;
        
        // Create component card
        const cardHtml = `
            <div class="component-card">
                <div class="component-header">
                    <div>
                        <div class="component-title">${componentName}</div>
                        <span class="m2-badge">M² Total: ${totalM2.toFixed(6)}</span>
                    </div>
                </div>
                
                <div class="row align-items-center">
                    <div class="col-md-3">
                        <label class="form-label small mb-1">Sisi</label>
                        <input type="number" 
                               class="form-control form-control-sm sisi-input" 
                               id="sisi-${componentIndex}"
                               data-component="${componentName}"
                               data-m2="${totalM2}"
                               data-index="${componentIndex}"
                               min="0"
                               step="1"
                               value="${existingSisi}"
                               placeholder="0">
                    </div>
                    <div class="col-md-9">
                        <div class="result-box">
                            <div class="row">
                                <div class="col-md-6">
                                    <small>Material Painting (M² × Sisi × 70.000):</small>
                                    <div class="value text-success" id="material-painting-${componentIndex}">Rp 0</div>
                                </div>
                                <div class="col-md-6">
                                    <small>Biaya Produksi Painting (M² × Sisi × 50.000):</small>
                                    <div class="value text-primary" id="biaya-produksi-painting-${componentIndex}">Rp 0</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        `;
        
        componentsList.insertAdjacentHTML('beforeend', cardHtml);
        
        // Add event listener to the input
        const input = document.getElementById(`sisi-${componentIndex}`);
        input.addEventListener('input', function() {
            const idx = this.dataset.index;
            const name = this.dataset.component;
            const m2 = parseFloat(this.dataset.m2);
            calculatePaintingCost(name, idx, m2);
        });
        
        // Calculate if there's existing data
        if (existingSisi > 0) {
            setTimeout(() => {
                calculatePaintingCost(componentName, componentIndex, totalM2);
            }, 100);
        }
        
        componentIndex++;
    });
    
    // Show modal
    const modal = new bootstrap.Modal(document.getElementById('paintingModal'));
    modal.show();
}

// ============================================
// CALCULATE PAINTING COST
// ============================================

function calculatePaintingCost(componentName, index, m2) {
    const sisiInput = document.getElementById(`sisi-${index}`);
    
    if (!sisiInput) {
        console.error('[CALCULATE] Input not found for index:', index);
        return;
    }
    
    const sisi = parseFloat(sisiInput.value) || 0;
    
    // Formula
    const materialPainting = m2 * sisi * 70000;
    const biayaProduksiPainting = m2 * sisi * 50000;
    
    // Update display
    const materialDisplay = document.getElementById(`material-painting-${index}`);
    const biayaDisplay = document.getElementById(`biaya-produksi-painting-${index}`);
    
    if (materialDisplay) {
        materialDisplay.textContent = formatRupiah(materialPainting);
    }
    
    if (biayaDisplay) {
        biayaDisplay.textContent = formatRupiah(biayaProduksiPainting);
    }
    
    // Store in window.paintingData
    if (sisi > 0) {
        window.paintingData[componentName] = {
            m2: m2,
            sisi: sisi,
            material_painting: materialPainting,
            biaya_produksi_painting: biayaProduksiPainting
        };
    } else {
        delete window.paintingData[componentName];
    }
}

// ============================================
// SAVE PAINTING DATA
// ============================================

function savePaintingData() {
    console.log('[SAVE] Current paintingData:', window.paintingData);
    
    if (!window.paintingData || Object.keys(window.paintingData).length === 0) {
        alert('⚠️ Tidak ada data painting yang diisi!');
        return;
    }
    
    // Show loading
    const saveBtn = document.querySelector('#paintingModal .btn-warning');
    const originalText = saveBtn.innerHTML;
    saveBtn.disabled = true;
    saveBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Menyimpan...';
    
    // Create clean copy of data
    const dataToSend = {};
    Object.keys(window.paintingData).forEach(key => {
        dataToSend[key] = {
            m2: window.paintingData[key].m2,
            sisi: window.paintingData[key].sisi,
            material_painting: window.paintingData[key].material_painting,
            biaya_produksi_painting: window.paintingData[key].biaya_produksi_painting
        };
    });
    
    fetch(`/invoice/bom/${invoiceId}/save-painting`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
            'Accept': 'application/json'
        },
        body: JSON.stringify({ painting_data: dataToSend })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            const itemCount = Object.keys(dataToSend).length;
            const materialTotal = data.total_material_painting || 0;
            const biayaTotal = data.total_biaya_produksi_painting || 0;
            
            alert(`✅ Painting cost berhasil disimpan!\n\nTotal Component: ${itemCount}\nMaterial Painting: ${formatRupiah(materialTotal)}\nBiaya Produksi: ${formatRupiah(biayaTotal)}`);
            
            // Update summary display
            document.getElementById('total-material-painting').textContent = formatRupiah(materialTotal);
            document.getElementById('total-biaya-produksi-painting').textContent = formatRupiah(biayaTotal);
            
            // Update border color
            const summaryBox = document.querySelector('.painting-summary-box');
            if (materialTotal > 0 || biayaTotal > 0) {
                summaryBox.style.border = '2px solid #28a745';
            }
            
            // Close modal
            bootstrap.Modal.getInstance(document.getElementById('paintingModal')).hide();
        } else {
            throw new Error(data.message || 'Gagal menyimpan data');
        }
    })
    .catch(error => {
        console.error('[SAVE] Error:', error);
        alert('❌ Terjadi kesalahan: ' + error.message);
    })
    .finally(() => {
        saveBtn.disabled = false;
        saveBtn.innerHTML = originalText;
    });
}

// ============================================
// FORMAT RUPIAH
// ============================================

function formatRupiah(amount) {
    return 'Rp ' + Math.round(amount).toLocaleString('id-ID');
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\Cost_Furniture\resources\views/invoice/bom/show.blade.php ENDPATH**/ ?>