<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
{
    Schema::create('activity_logs', function (Blueprint $table) {
        $table->id();
        $table->string('user_name')->nullable();
        $table->unsignedBigInteger('user_id')->nullable();
        $table->string('action')->nullable(); // misal: view, create, update, delete
        $table->string('model_type')->nullable(); // nama model misal: ItemRequest
        $table->unsignedBigInteger('model_id')->nullable();
        $table->text('description')->nullable(); // detail aktivitas
        $table->json('changes')->nullable(); // before-after data
        $table->string('ip_address')->nullable();
        $table->string('url')->nullable();
        $table->string('method')->nullable();
        $table->timestamps();
    });
}

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('activity_logs');
    }
};
