<?php
// File: employer/employer_dashboard.php

// 1. Matikan Cache
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Pragma: no-cache");

include 'auth_check.php';
require_role(['employer']); 
require_once('../db.php'); 

$username = $_SESSION['username'] ?? 'Employer';
$employer_id = $_SESSION['user_id'];

// --- 1. NOTIFIKASI COUNTER ---
$sql_notif = "SELECT COUNT(*) as total_notif FROM tasks WHERE creator_id = ? AND status IN ('pending', 'in_progress')";
$stmt_notif = $conn->prepare($sql_notif);
$stmt_notif->bind_param("i", $employer_id);
$stmt_notif->execute();
$notif_count = $stmt_notif->get_result()->fetch_assoc()['total_notif'];
$stmt_notif->close();

// --- 2. LOGIKA FILTER & PAGINATION ---
$filter_type = isset($_GET['filter']) ? $_GET['filter'] : ''; 
$limit = 5; 
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// Hitung Total
$sql_count_base = "SELECT COUNT(*) as total FROM tasks WHERE creator_id = ?";
if ($filter_type == 'active') {
    $sql_count_base .= " AND status IN ('pending', 'in_progress')";
}
$stmt_count = $conn->prepare($sql_count_base);
$stmt_count->bind_param("i", $employer_id);
$stmt_count->execute();
$res_count = $stmt_count->get_result();
$row_count = $res_count->fetch_assoc();
$total_records = $row_count['total'];
$total_pages = ceil($total_records / $limit);
$stmt_count->close();

// Ambil Data
$sql = "
    SELECT 
        t.*, 
        p.project_name, 
        m.username AS member_name
    FROM tasks t
    JOIN projects p ON t.project_id = p.project_id
    JOIN users m ON t.assigned_to = m.id
    WHERE t.creator_id = ?
";

if ($filter_type == 'active') {
    $sql .= " AND t.status IN ('pending', 'in_progress')";
}

$sql .= " ORDER BY t.id DESC LIMIT ? OFFSET ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("iii", $employer_id, $limit, $offset);
$stmt->execute();
$result = $stmt->get_result();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <title>Dashboard Employer</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700;800&display=swap" rel="stylesheet">
    <style>
        :root { --primary: #007bff; --bg: #f0f2f5; }
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
        body { background-color: var(--bg); color: #444; padding-bottom: 50px; margin: 0; }

        /* HERO HEADER */
        .hero {
            background: linear-gradient(135deg, #007bff, #0056b3);
            color: white;
            padding: 20px 30px; 
            border-bottom: 4px solid #0056b3; 
            box-shadow: 0 4px 15px rgba(0, 123, 255, 0.15);
            position: sticky; top: 0; z-index: 1000;
            display: flex; justify-content: space-between; align-items: center;
        }
        
        .header-left { display: flex; align-items: center; gap: 15px; overflow: hidden; /* Mencegah teks tumpah */ }
        
        /* LOGO TEXT */
        .logo-text { 
            font-size: 22px; font-weight: 800; color: white; text-transform: uppercase; 
            border-right: 2px solid rgba(255,255,255,0.3); padding-right: 15px; 
            display: block; white-space: nowrap; flex-shrink: 0; /* Logo jangan mengecil */
        }
        .logo-desktop { display: inline; } 
        .logo-mobile { display: none; }

        .header-title { overflow: hidden; }
        .header-title h1 { 
            font-size: 20px; font-weight: 700; margin: 0; color: white; 
            white-space: nowrap; overflow: hidden; text-overflow: ellipsis; /* Nama panjang jadi ... */
        }
        .header-title p { opacity: 0.8; font-weight: 300; font-size: 12px; margin: 0; color: white; }

        /* KANAN ATAS */
        .top-right-area { display: flex; align-items: center; gap: 15px; flex-shrink: 0; }

        .notif-wrapper { position: relative; cursor: pointer; display: flex; align-items: center; text-decoration: none; }
        .icon-bell { width: 26px; height: 26px; fill: white; transition: 0.2s; }
        .notif-wrapper.active .icon-bell { fill: #ffeb3b; filter: drop-shadow(0 0 5px rgba(255, 235, 59, 0.8)); }
        .notif-wrapper:hover .icon-bell { transform: scale(1.1); }
        .notif-badge { position: absolute; top: -5px; right: -5px; background-color: #ff3333; color: white; font-size: 10px; font-weight: 700; padding: 2px 6px; border-radius: 50px; border: 2px solid #0056b3; }

        .btn-logout-top { background-color: #ff3333; color: white; padding: 8px 20px; border-radius: 50px; text-decoration: none; font-weight: 700; font-size: 12px; border: 2px solid white; box-shadow: 0 4px 10px rgba(0,0,0,0.2); transition: 0.3s; }
        .btn-logout-top:hover { background-color: white; color: #ff3333; transform: translateY(-2px); }

        /* CONTAINER */
        .container { max-width: 1000px; margin: 30px auto 0; padding: 0 20px; }

        /* ACTION CARD */
        .action-card { background: white; padding: 25px; border-radius: 12px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); text-align: center; margin-bottom: 25px; border-top: 4px solid #007bff; }
        .action-card h2 { margin: 0; font-size: 20px; color: #333; }
        .action-card p { margin: 5px 0 15px; font-size: 13px; color: #666; }

        .btn-create { background: linear-gradient(45deg, #11998e, #38ef7d); color: white; padding: 12px 30px; text-decoration: none; font-size: 15px; font-weight: 700; border-radius: 50px; display: inline-block; box-shadow: 0 5px 15px rgba(56, 239, 125, 0.3); transition: 0.3s; }
        .btn-create:hover { transform: translateY(-3px); }

        /* TABLE SECTION */
        .table-section { background: white; padding: 25px; border-radius: 16px; box-shadow: 0 5px 20px rgba(0,0,0,0.05); }
        .section-header { font-size: 18px; font-weight: 700; margin-bottom: 20px; color: #333; border-left: 5px solid #007bff; padding-left: 10px; display: flex; justify-content: space-between; align-items: center; }
        .reset-filter { font-size: 12px; color: #ff3333; text-decoration: none; font-weight: 600; }

        .table-responsive { overflow-x: auto; }
        table { width: 100%; border-collapse: collapse; }
        th { background: #f8f9fa; padding: 15px; text-align: left; font-size: 12px; text-transform: uppercase; color: #666; letter-spacing: 1px; font-weight: 700; }
        td { padding: 15px; border-bottom: 1px solid #eee; font-size: 14px; vertical-align: middle; }
        .badge { padding: 6px 12px; border-radius: 6px; font-size: 11px; font-weight: 700; text-transform: uppercase; display: inline-block; }
        .bg-pending { background-color: #fffbeb; color: #b45309; } .bg-in_progress { background-color: #eff6ff; color: #1d4ed8; } .bg-completed { background-color: #ecfdf5; color: #047857; }
        
        /* TOMBOL AKSI */
        .action-buttons { display: flex; gap: 5px; }
        .btn-detail { background: #333; color: white; padding: 6px 12px; border-radius: 6px; text-decoration: none; font-size: 12px; font-weight: 600; display: inline-block; flex: 1; text-align: center; }
        .btn-detail:hover { background: #000; }
        
        /* TOMBOL HAPUS */
        .btn-delete { background: #ffebee; color: #c62828; padding: 6px 12px; border-radius: 6px; text-decoration: none; font-size: 12px; font-weight: 600; display: inline-block; border: 1px solid #ffcdd2; transition: 0.2s; flex: 1; text-align: center; }
        .btn-delete:hover { background: #ef9a9a; color: white; border-color: #ef9a9a; }

        .pagination { margin-top: 25px; text-align: center; }
        .page-link { display: inline-block; padding: 8px 14px; margin: 0 4px; border: 1px solid #e0e0e0; color: #555; text-decoration: none; border-radius: 6px; font-size: 13px; }
        .page-link.active { background-color: #007bff; color: white; }

        /* --- MOBILE RESPONSIVE (LAYOUT FIX) --- */
        @media screen and (max-width: 768px) {
            .hero { padding: 15px; }
            
            /* LOGO & TITLE ALIGNMENT FIX */
            .logo-desktop { display: none; }
            .logo-mobile { display: inline; font-size: 20px; }
            .logo-text { padding-right: 10px; border-right: 2px solid rgba(255,255,255,0.3); }
            
            /* Agar Nama User + TM tidak nabrak */
            .header-left { gap: 10px; flex: 1; min-width: 0; } /* Flex 1 agar mengisi ruang sisa */
            .header-title h1 { 
                font-size: 16px; 
                white-space: nowrap; 
                overflow: hidden; 
                text-overflow: ellipsis; /* Nama panjang jadi ... */
                max-width: 100%; 
            }
            .header-title p { display: none; } /* Sembunyikan subtitle "Employer Dashboard" di HP */

            /* TOMBOL KECIL DI HP */
            .top-right-area { gap: 10px; }
            .btn-logout-top { padding: 6px 10px; font-size: 10px; }
            .icon-bell { width: 22px; height: 22px; }

            /* CARD VIEW */
            table, thead, tbody, th, td, tr { display: block; }
            thead tr { position: absolute; top: -9999px; left: -9999px; }
            tr { margin-bottom: 15px; background: white; border-radius: 10px; box-shadow: 0 2px 8px rgba(0,0,0,0.05); border: 1px solid #e5e7eb; padding: 15px; }
            td { border: none; position: relative; padding: 5px 0; padding-left: 40%; display: flex; justify-content: space-between; align-items: center; text-align: right; font-size: 13px; }
            td:before { content: attr(data-label); position: absolute; left: 0; width: 35%; font-weight: 700; font-size: 11px; color: #6b7280; text-align: left; text-transform: uppercase; }
            
            td[data-label="JUDUL"] { font-size: 16px; font-weight: 700; color: #111; display: block; text-align: left; padding-left: 0; margin-bottom: 10px; border-bottom: 1px dashed #eee; padding-bottom: 10px; } td[data-label="JUDUL"]:before { display: none; }
            td[data-label="PROJECT"] span { background: #eff6ff; padding: 2px 8px; border-radius: 4px; color: #2563eb; font-weight: 600; }
            
            /* FULL WIDTH BUTTONS DI HP */
            td[data-label="AKSI"] { margin-top: 15px; padding-top: 10px; border-top: 1px solid #f3f4f6; padding-left: 0; display: block; text-align: center; } td[data-label="AKSI"]:before { display: none; }
            .action-buttons { width: 100%; display: flex; gap: 10px; }
            .btn-detail, .btn-delete { flex: 1; text-align: center; padding: 10px; }
        }
    </style>
</head>
<body>

    <div class="hero">
        <div class="header-left">
            <div class="logo-text">
                <span class="logo-desktop">TASK MANAGEMENT</span>
                <span class="logo-mobile">TM</span>
            </div>
            <div class="header-title">
                <h1>Hi, <?php echo htmlspecialchars($username); ?></h1>
                <p>Employer Dashboard</p>
            </div>
        </div>

        <div class="top-right-area">
            <a href="employer_dashboard.php?filter=active" class="notif-wrapper <?php echo ($filter_type == 'active') ? 'active' : ''; ?>" title="Lihat Tugas Berjalan">
                <svg class="icon-bell" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M12.02 24c1.1 0 2-.9 2-2h-4c0 1.1.9 2 2 2zm10-6v-5.5c0-3.07-2.13-5.64-5-6.32V6c0-2.76-2.24-5-5-5s-5 2.24-5 5v.18c-2.87.68-5 3.25-5 6.32V18l-2 2v1h24v-1l-2-2z"/></svg>
                <?php if ($notif_count > 0): ?><span class="notif-badge"><?php echo $notif_count; ?></span><?php endif; ?>
            </a>
            <a href="../logout.php" class="btn-logout-top">LOGOUT</a>
        </div>
    </div>

    <div class="container">
        <div class="action-card">
            <h2 style="margin-top: 0; font-size: 20px;">🚀 Mulai Proyek Baru</h2>
            <p style="color: #666; margin-bottom: 5px; font-size: 14px;">Berikan tugas kepada member dan lampirkan file.</p>
            <a href="employer_create_task.php" class="btn-create">➕ Buat Tugas Baru</a>
        </div>

        <div class="table-section">
            <div class="section-header">
                <div><?php if ($filter_type == 'active'): ?>⏳ Tugas Berjalan<?php else: ?>📊 Semua Tugas Anda<?php endif; ?></div>
                <?php if ($filter_type == 'active'): ?><a href="employer_dashboard.php" class="reset-filter">❌ Reset</a><?php endif; ?>
            </div>
            
            <div class="table-responsive">
                <?php if ($result->num_rows > 0): ?>
                    <table width="100%">
                        <thead><tr><th>Judul Tugas</th><th>Project</th><th>Ditugaskan Ke</th><th>Deadline</th><th>Status</th><th>Aksi</th></tr></thead>
                        <tbody>
                            <?php while ($row = $result->fetch_assoc()): ?>
                                <?php 
                                    $clean = strtolower(trim($row['status'] ?? ''));
                                    if(empty($clean)) $clean = 'pending';
                                ?>
                                <tr>
                                    <td data-label="JUDUL"><?php echo htmlspecialchars($row['title']); ?></td>
                                    <td data-label="PROJECT"><span style="background:#f3f4f6; padding:2px 8px; border-radius:4px; color:#555; font-size:12px; border:1px solid #eee;"><?php echo htmlspecialchars($row['project_name']); ?></span></td>
                                    <td data-label="PENERIMA"><?php echo htmlspecialchars($row['member_name']); ?></td>
                                    <td data-label="DEADLINE" style="color:#d32f2f; font-weight:600;"><?php echo htmlspecialchars($row['due_date']); ?></td>
                                    <td data-label="STATUS"><span class="badge bg-<?php echo $clean; ?>"><?php echo strtoupper(str_replace('_', ' ', $clean)); ?></span></td>
                                    
                                    <td data-label="AKSI">
                                        <div class="action-buttons">
                                            <a href="employer_view_task.php?task_id=<?php echo $row['id']; ?>" class="btn-detail">Lihat Detail</a>
                                            <a href="employer_delete_task.php?id=<?php echo $row['id']; ?>" class="btn-delete" onclick="return confirm('⚠️ Yakin hapus tugas ini?');">Hapus</a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                    <div class="pagination">
                        <?php $link_filter = ($filter_type) ? "&filter=$filter_type" : ""; ?>
                        <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                            <a href="?page=<?php echo $i . $link_filter; ?>" class="page-link <?php echo ($i == $page) ? 'active' : ''; ?>"><?php echo $i; ?></a>
                        <?php endfor; ?>
                    </div>
                <?php else: ?>
                    <div style="text-align: center; padding: 40px; color: #999;"><p>Tidak ada tugas.</p></div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</body>
</html>