<?php
// File: employer/employer_view_task.php

include 'auth_check.php';
require_role(['employer']); 
require_once('../db.php'); 

if (!isset($_GET['task_id']) || !is_numeric($_GET['task_id'])) {
    die("ID Tugas tidak valid.");
}
$task_id = (int)$_GET['task_id'];
$employer_id = $_SESSION['user_id'];

// 1. Ambil Detail Tugas (Pastikan tugas ini dibuat oleh employer yang sedang login)
$sql = "
    SELECT 
        t.*, 
        p.project_name, 
        m.username AS member_name
    FROM tasks t
    JOIN projects p ON t.project_id = p.project_id
    LEFT JOIN users m ON t.assigned_to = m.id
    WHERE t.id = ? AND t.creator_id = ?
";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ii", $task_id, $employer_id);
$stmt->execute();
$result = $stmt->get_result();
$task = $result->fetch_assoc();

if (!$task) {
    die("Tugas tidak ditemukan atau Anda tidak memiliki akses.");
}

// 2. Ambil Attachment
$sql_att = "SELECT * FROM task_attachments WHERE task_id = ?";
$stmt_att = $conn->prepare($sql_att);
$stmt_att->bind_param("i", $task_id);
$stmt_att->execute();
$attachment = $stmt_att->get_result()->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <title>Detail Tugas - <?php echo htmlspecialchars($task['title']); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        /* --- GLOBAL STYLE (DESKTOP DEFAULT) --- */
        :root { --bg: #f0f2f5; --primary: #007bff; --text: #333; }
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
        body { background-color: var(--bg); padding: 40px 20px; color: var(--text); }

        .container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            border-radius: 16px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.05);
            overflow: hidden;
            border-top: 5px solid var(--primary);
        }

        /* TOP BAR */
        .top-bar {
            padding: 20px 30px;
            border-bottom: 1px solid #eee;
            background: #fff;
        }
        .btn-back {
            text-decoration: none;
            color: #666;
            font-size: 14px;
            font-weight: 600;
            display: inline-flex; align-items: center; gap: 5px;
            transition: 0.2s;
        }
        .btn-back:hover { color: var(--primary); }

        /* HEADER CONTENT */
        .content { padding: 30px; }
        .task-header { margin-bottom: 25px; }
        .task-title { font-size: 28px; font-weight: 700; color: #111; margin-bottom: 10px; line-height: 1.3; }
        
        /* BADGES */
        .badge { padding: 6px 14px; border-radius: 6px; font-size: 12px; font-weight: 700; text-transform: uppercase; display: inline-block; vertical-align: middle; margin-left: 10px; }
        .bg-pending { background-color: #fffbeb; color: #b45309; }
        .bg-in_progress { background-color: #eff6ff; color: #1d4ed8; }
        .bg-completed { background-color: #dcfce7; color: #166534; }

        /* INFO GRID */
        .info-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr); /* 3 Kolom di Desktop */
            gap: 20px;
            background: #f8f9fa;
            padding: 20px;
            border-radius: 12px;
            margin-bottom: 30px;
            border: 1px solid #e9ecef;
        }
        .info-item h4 { font-size: 11px; color: #888; text-transform: uppercase; margin-bottom: 5px; letter-spacing: 0.5px; font-weight: 600; }
        .info-item p { font-size: 15px; font-weight: 600; color: #333; }

        /* DESCRIPTION */
        .section-label { font-size: 14px; font-weight: 700; color: #555; margin-bottom: 10px; display: block; text-transform: uppercase; }
        .desc-box { font-size: 15px; line-height: 1.7; color: #444; margin-bottom: 30px; white-space: pre-line; }

        /* FILE CARD */
        .file-card {
            display: flex; align-items: center; gap: 15px;
            background: #fff; border: 1px solid #e9ecef;
            padding: 15px; border-radius: 10px;
            max-width: 400px; transition: 0.2s;
        }
        .file-card:hover { border-color: var(--primary); background: #f0f7ff; }
        .file-icon { font-size: 24px; }
        .file-link { text-decoration: none; color: var(--primary); font-weight: 600; font-size: 13px; }

        /* --- MOBILE RESPONSIVE (HANYA AKTIF DI HP) --- */
        @media screen and (max-width: 768px) {
            body { padding: 15px; }
            .container { border-radius: 12px; }
            .content { padding: 20px; }
            
            /* Judul Lebih Kecil */
            .task-title { font-size: 22px; }
            
            /* Grid Jadi Stack (Tumpuk ke Bawah) */
            .info-grid { 
                grid-template-columns: 1fr; /* 1 Kolom */
                gap: 15px; 
            }
            .info-item { 
                border-bottom: 1px dashed #eee; 
                padding-bottom: 10px; 
            }
            .info-item:last-child { border-bottom: none; padding-bottom: 0; }
            
            /* Badge turun ke bawah judul */
            .badge { display: inline-block; margin-left: 0; margin-top: 5px; }

            /* File Card Full Width */
            .file-card { max-width: 100%; }
        }
    </style>
</head>
<body>

<div class="container">
    <div class="top-bar">
        <a href="employer_dashboard.php" class="btn-back">← Kembali ke Dashboard</a>
    </div>

    <div class="content">
        <div class="task-header">
            <div class="task-title">
                <?php echo htmlspecialchars($task['title']); ?>
                <?php 
                    $clean_status = strtolower($task['status'] ?? 'pending');
                    if(empty($clean_status)) $clean_status = 'pending';
                ?>
                <br class="mobile-break"> <span class="badge bg-<?php echo $clean_status; ?>">
                    <?php echo strtoupper(str_replace('_', ' ', $clean_status)); ?>
                </span>
            </div>
        </div>

        <div class="info-grid">
            <div class="info-item">
                <h4>Project</h4>
                <p><?php echo htmlspecialchars($task['project_name']); ?></p>
            </div>
            <div class="info-item">
                <h4>Ditugaskan Ke</h4>
                <p>👤 <?php echo htmlspecialchars($task['member_name']); ?></p>
            </div>
            <div class="info-item">
                <h4>Deadline</h4>
                <p style="color: #dc3545;"><?php echo htmlspecialchars($task['due_date']); ?></p>
            </div>
        </div>

        <span class="section-label">Deskripsi Tugas</span>
        <div class="desc-box">
            <?php echo nl2br(htmlspecialchars($task['description'])); ?>
        </div>

        <?php if ($attachment): ?>
            <span class="section-label">Lampiran File</span>
            <div class="file-card">
                <div class="file-icon">📎</div>
                <div>
                    <div style="font-size:11px; color:#888; margin-bottom:2px;">File Pendukung:</div>
                    <a href="../download.php?file=<?php echo urlencode($attachment['unique_file_name']); ?>" class="file-link" target="_blank">
                        <?php echo htmlspecialchars($attachment['original_file_name']); ?>
                    </a>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

</body>
</html>