<?php
session_start();

// 1. CEK LOGIN OTOMATIS
// Jika user sudah login, jangan suruh login lagi, langsung lempar ke dashboard
if (isset($_SESSION['user_id']) && isset($_SESSION['role'])) {
    $role = $_SESSION['role'];
    if ($role == 'superadmin') {
        header("Location: superadmin/superadmin_dashboard.php");
    } elseif ($role == 'employer') {
        header("Location: employer/employer_dashboard.php");
    } elseif ($role == 'member') {
        header("Location: member/member_dashboard.php");
    }
    exit;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Welcome - Task Management System</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;800&family=Fugaz+One&display=swap" rel="stylesheet">
    <style>
        /* RESET */
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
        
        body {
            height: 100vh;
            background-color: #f4f6f9;
            display: flex;
            flex-direction: column;
            overflow: hidden;
        }

        /* --- BACKGROUND IMAGE (FULL SCREEN) --- */
        .bg-image {
            position: absolute;
            top: 0; left: 0; width: 100%; height: 100%;
            /* Gambar Hutan Segar + Overlay Gelap Transparan */
            background-image: 
                linear-gradient(rgba(0, 20, 10, 0.6), rgba(0, 20, 10, 0.4)),
                url('https://images.unsplash.com/photo-1542273917363-3b1817f69a2d?q=80&w=2560&auto=format&fit=crop');
            background-size: cover;
            background-position: center;
            z-index: -1;
        }

        /* --- NAVBAR --- */
        .navbar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 25px 50px;
            width: 100%;
        }

        .logo {
            font-family: 'Fugaz One', cursive;
            font-size: 28px;
            color: white;
            text-transform: uppercase;
            letter-spacing: 1px;
            text-decoration: none;
        }
        .logo span { color: #39ff14; /* Hijau Neon */ }

        .btn-login-nav {
            text-decoration: none;
            color: white;
            font-weight: 600;
            border: 2px solid white;
            padding: 10px 25px;
            border-radius: 50px;
            transition: 0.3s;
            font-size: 14px;
        }
        .btn-login-nav:hover {
            background: white;
            color: #111;
        }

        /* --- HERO CONTENT (TENGAH) --- */
        .hero-content {
            flex: 1;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            text-align: center;
            padding: 20px;
            color: white;
        }

        .hero-title {
            font-size: 64px;
            font-weight: 800;
            line-height: 1.1;
            margin-bottom: 20px;
            letter-spacing: -1px;
            text-shadow: 0 4px 10px rgba(0,0,0,0.3);
        }
        
        .hero-subtitle {
            font-size: 18px;
            max-width: 600px;
            margin-bottom: 40px;
            opacity: 0.9;
            font-weight: 300;
        }

        .btn-start {
            background: linear-gradient(90deg, #39ff14, #32e012);
            color: #000;
            padding: 18px 50px;
            font-size: 18px;
            font-weight: 700;
            border-radius: 50px;
            text-decoration: none;
            box-shadow: 0 10px 30px rgba(57, 255, 20, 0.4);
            transition: transform 0.2s, box-shadow 0.2s;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        .btn-start:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 40px rgba(57, 255, 20, 0.6);
        }

        /* --- FOOTER --- */
        .footer {
            text-align: center;
            padding: 20px;
            color: rgba(255,255,255,0.6);
            font-size: 12px;
        }

        /* Responsif untuk HP */
        @media (max-width: 768px) {
            .navbar { padding: 20px; }
            .hero-title { font-size: 42px; }
            .hero-subtitle { font-size: 16px; }
        }
    </style>
</head>
<body>

    <div class="bg-image"></div>

    <div class="navbar">
        <a href="#" class="logo">TASK <span>MANAGEMENT</span></a>
    </div>

    <div class="hero-content">
        <h1 class="hero-title">Kelola Tugas<br>Lebih Efisien</h1>
        <p class="hero-subtitle">
            Platform manajemen tugas yang dirancang untuk Employer dan Member. 
            Pantau progres, lampirkan file, dan selesaikan pekerjaan tepat waktu.
        </p>
        
        <a href="login.php" class="btn-start">Mulai Sekarang 🚀</a>
    </div>

    <div class="footer">
        &copy; 2025 Task Management System. All Rights Reserved.
    </div>

</body>
</html>