<?php
// File: superadmin/superadmin_create_user.php

include 'auth_check.php';
require_role(['superadmin']); 
require_once('../db.php'); 

$message = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validasi sederhana
    if (empty($_POST['username']) || empty($_POST['password']) || empty($_POST['role'])) {
        $message = "Semua field harus diisi!";
    } elseif (!in_array($_POST['role'], ['employer', 'member', 'superadmin'])) {
        $message = "Role tidak valid.";
    } else {
        $username = trim($_POST['username']);
        $password_input = $_POST['password'];
        $role = $_POST['role'];

        if (strlen($username) < 4) {
            $message = "Username minimal 4 karakter.";
        } elseif (strlen($password_input) < 6) {
            $message = "Password minimal 6 karakter.";
        } else {
            // Cek Username
            $check_stmt = mysqli_prepare($conn, "SELECT username FROM users WHERE username = ?");
            mysqli_stmt_bind_param($check_stmt, "s", $username);
            mysqli_stmt_execute($check_stmt);
            mysqli_stmt_store_result($check_stmt);

            if (mysqli_stmt_num_rows($check_stmt) > 0) {
                $message = "Username **sudah terpakai**!";
            } else {
                $hashed_password = password_hash($password_input, PASSWORD_DEFAULT);
                $insert_stmt = mysqli_prepare($conn, "INSERT INTO users (username, password, role) VALUES (?, ?, ?)");
                mysqli_stmt_bind_param($insert_stmt, "sss", $username, $hashed_password, $role);
                
                if (mysqli_stmt_execute($insert_stmt)) {
                    $message = "✅ User **berhasil dibuat**!";
                } else {
                    $message = "❌ Gagal membuat user! Error: " . mysqli_error($conn); 
                }
                mysqli_stmt_close($insert_stmt);
            }
            mysqli_stmt_close($check_stmt);
        }
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <title>Create User</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    <style>
        :root { --primary: #2196F3; --bg: #f4f6f9; }
        body { font-family: 'Poppins', sans-serif; background-color: var(--bg); display: flex; justify-content: center; align-items: center; min-height: 100vh; margin: 0; }
        
        .card { background: white; padding: 40px; border-radius: 16px; box-shadow: 0 10px 30px rgba(0,0,0,0.05); width: 100%; max-width: 500px; border-top: 5px solid var(--primary); }
        .header { margin-bottom: 30px; text-align: center; }
        h2 { margin: 0; color: #333; }
        p { color: #666; font-size: 14px; margin-top: 5px; }

        .form-group { margin-bottom: 20px; }
        label { display: block; margin-bottom: 8px; font-weight: 600; color: #555; font-size: 14px; }
        
        /* CONTAINER PASSWORD (Agar ikon bisa di dalam) */
        .password-container { position: relative; width: 100%; }
        
        input, select { width: 100%; padding: 12px 15px; border: 1px solid #ddd; border-radius: 8px; font-family: 'Poppins'; font-size: 14px; transition: 0.3s; box-sizing: border-box; }
        input:focus, select:focus { outline: none; border-color: var(--primary); box-shadow: 0 0 0 3px rgba(33, 150, 243, 0.1); }

        /* ICON MATA */
        .toggle-password {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: #888;
            font-size: 18px;
            user-select: none; /* Supaya tidak terblok saat diklik */
        }
        .toggle-password:hover { color: var(--primary); }

        .btn-submit { width: 100%; background-color: var(--primary); color: white; padding: 14px; border: none; border-radius: 8px; font-weight: 700; cursor: pointer; transition: 0.3s; margin-top: 10px; }
        .btn-submit:hover { background-color: #1976D2; transform: translateY(-2px); }

        .btn-back { display: block; text-align: center; margin-top: 20px; text-decoration: none; color: #777; font-size: 13px; font-weight: 500; }
        .btn-back:hover { color: #333; }

        .alert { padding: 15px; border-radius: 8px; margin-bottom: 20px; font-size: 14px; text-align: center; }
        .success { background: #e3f2fd; color: #0d47a1; border: 1px solid #bbdefb; }
        .error { background: #ffebee; color: #c62828; border: 1px solid #ffcdd2; }
    </style>
</head>
<body>

<div class="card">
    <div class="header">
        <h2>👤 Tambah User Baru</h2>
        <p>Silakan isi data untuk membuat akun baru.</p>
    </div>

    <?php if ($message): ?>
        <div class="alert <?php echo strpos($message, 'berhasil') !== false ? 'success' : 'error'; ?>">
            <?php echo $message; ?>
        </div>
    <?php endif; ?>

    <form method="POST">
        <div class="form-group">
            <label>Username</label>
            <input type="text" name="username" required minlength="4" placeholder="Masukkan username unik...">
        </div>

        <div class="form-group">
            <label>Password</label>
            <div class="password-container">
                <input type="password" name="password" id="passwordInput" required minlength="6" placeholder="Minimal 6 karakter...">
                <span class="toggle-password" onclick="togglePassword()">👁️</span>
            </div>
        </div>

        <div class="form-group">
            <label>Role / Jabatan</label>
            <select name="role" required>
                <option value="">-- Pilih Role --</option>
                <option value="employer">Employer (Pemberi Tugas)</option>
                <option value="member">Member (Penerima Tugas)</option>
                <option value="superadmin">Superadmin</option>
            </select>
        </div>

        <button type="submit" class="btn-submit">✅ BUAT USER</button>
    </form>

    <a href="superadmin_dashboard.php" class="btn-back">← Kembali ke Dashboard</a>
</div>

<script>
    function togglePassword() {
        const passwordInput = document.getElementById("passwordInput");
        const toggleIcon = document.querySelector(".toggle-password");

        if (passwordInput.type === "password") {
            passwordInput.type = "text";
            toggleIcon.textContent = "🙈"; // Ubah ikon jadi mata tertutup (atau ganti sesuai selera)
        } else {
            passwordInput.type = "password";
            toggleIcon.textContent = "👁️"; // Kembali ke mata terbuka
        }
    }
</script>

</body>
</html>