<?php
// File: superadmin/superadmin_list_user.php

// 1. Matikan Cache
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Pragma: no-cache");

require_once('../db.php'); 
include 'auth_check.php';
require_role(['superadmin']); 
$username_session = $_SESSION['username'] ?? 'Superadmin';

// --- LOGIKA PENCARIAN & PAGINATION ---
$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$limit = 5; 
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// 1. Hitung Total Data
$sql_count = "SELECT COUNT(*) as total FROM users";
if (!empty($search)) {
    $sql_count .= " WHERE username LIKE '%$search%' OR role LIKE '%$search%'";
}
$res_count = mysqli_query($conn, $sql_count);
$total_records = mysqli_fetch_assoc($res_count)['total'];
$total_pages = ceil($total_records / $limit);

// 2. Ambil Data User
$query = "SELECT * FROM users";
if (!empty($search)) {
    $query .= " WHERE username LIKE '%$search%' OR role LIKE '%$search%'";
}
$query .= " ORDER BY id DESC LIMIT $limit OFFSET $offset";
$result = mysqli_query($conn, $query);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <title>Daftar User</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700;800&display=swap" rel="stylesheet">
    <style>
        /* --- STYLE SUPERADMIN (SERAGAM) --- */
        :root { --primary: #2196F3; --accent: #39ff14; --bg: #f4f6f9; }
        * { margin: 0; padding: 0; box-sizing: border-box; font-family: 'Poppins', sans-serif; }
        body { background-color: var(--bg); color: #333; padding-bottom: 50px; }

        /* HEADER (STICKY) */
        .header {
            position: sticky; top: 0; z-index: 1000;
            background: linear-gradient(135deg, #1a1a1a, #2c3e50);
            color: white;
            padding: 20px 30px 25px;
            text-align: center;
            border-bottom: 4px solid var(--accent);
            box-shadow: 0 4px 20px rgba(0,0,0,0.2);
            margin-bottom: 30px;
            display: flex; justify-content: space-between; align-items: center;
        }
        
        /* LOGO KIRI */
        .header-left .text-brand { font-size: 22px; font-weight: 800; color: white; text-transform: uppercase; letter-spacing: 0.5px; }
        .header-left .text-brand span { color: var(--accent); }

        /* JUDUL TENGAH */
        .header-center { position: absolute; left: 50%; transform: translateX(-50%); text-align: center; }
        .header-center h1 { font-size: 28px; font-weight: 700; margin: 0; letter-spacing: 1px; }
        .header-center p { font-size: 14px; opacity: 0.9; margin-top: 5px; }

        /* LOGOUT KANAN */
        .btn-logout-top {
            background-color: #ff3333; color: white; padding: 8px 20px; border-radius: 50px; text-decoration: none; font-weight: 700; font-size: 12px; border: 2px solid white; box-shadow: 0 4px 10px rgba(0,0,0,0.3); transition: 0.3s;
        }
        .btn-logout-top:hover { background-color: white; color: #ff3333; }

        /* CONTAINER */
        .container { max-width: 1200px; margin: 0 auto; padding: 0 20px; }
        
        .monitoring-section { background: white; padding: 30px; border-radius: 15px; box-shadow: 0 5px 20px rgba(0,0,0,0.05); }
        
        .section-header { 
            display: flex; justify-content: space-between; align-items: center; 
            margin-bottom: 20px; border-bottom: 2px solid #eee; padding-bottom: 15px; 
        }
        .section-title { font-size: 24px; font-weight: 700; margin: 0; }
        
        .btn-add { 
            background: var(--primary); color: white; text-decoration: none; padding: 10px 20px; border-radius: 8px; font-weight: 600; font-size: 14px; box-shadow: 0 4px 10px rgba(33, 150, 243, 0.3); transition: 0.2s; 
        }
        .btn-add:hover { background: #1976D2; transform: translateY(-2px); }

        .btn-back { text-decoration: none; color: #666; font-weight: 600; font-size: 14px; display: flex; align-items: center; gap: 5px; margin-bottom: 20px; }
        .btn-back:hover { color: #000; }

        /* SEARCH FORM */
        .filter-form { background: #f8f9fa; padding: 15px; border-radius: 10px; display: flex; gap: 15px; align-items: center; margin-bottom: 20px; }
        .filter-form input { padding: 10px; border-radius: 5px; border: 1px solid #ddd; flex: 1; }
        .btn-filter { background: #333; color: white; border: none; padding: 10px 20px; border-radius: 5px; cursor: pointer; font-weight: bold; }
        .reset-filter { color: #d32f2f; font-weight: 600; text-decoration: none; font-size: 13px; }

        /* TABLE */
        .table-responsive { overflow-x: auto; }
        table { width: 100%; border-collapse: collapse; }
        th { background: #333; color: white; padding: 15px; text-align: left; font-size: 14px; text-transform: uppercase; }
        td { padding: 15px; border-bottom: 1px solid #eee; font-size: 15px; vertical-align: middle; }
        
        /* ROLE BADGES */
        .badge { padding: 5px 12px; border-radius: 50px; font-size: 11px; font-weight: 700; text-transform: uppercase; display: inline-block; }
        .role-superadmin { background: #212121; color: white; }
        .role-employer { background: #e3f2fd; color: #1976D2; border: 1px solid #bbdefb; }
        .role-member { background: #fff3e0; color: #ef6c00; border: 1px solid #ffe0b2; }

        /* ACTIONS */
        .btn-edit { text-decoration: none; color: white; background: #4CAF50; padding: 5px 10px; border-radius: 5px; font-size: 12px; font-weight: 600; margin-right: 5px; }
        .btn-edit:hover { background: #388E3C; }
        .btn-delete { text-decoration: none; color: white; background: #d32f2f; padding: 5px 10px; border-radius: 5px; font-size: 12px; font-weight: 600; }
        .btn-delete:hover { background: #b71c1c; }

        /* PAGINATION */
        .pagination { margin-top: 30px; text-align: center; }
        .page-link { display: inline-block; padding: 8px 14px; margin: 0 4px; border: 1px solid #ddd; color: #333; text-decoration: none; border-radius: 6px; }
        .page-link.active { background-color: #333; color: white; }
    </style>
</head>
<body>

    <div class="header">
        <div class="header-left"><div class="text-brand">TASK <span>MANAGEMENT</span></div></div>
        <div class="header-center">
            <h1>👥 Manajemen User</h1>
            <p>Superadmin Panel</p>
        </div>
        <div class="header-right">
            <a href="../logout.php" class="btn-logout-top">LOGOUT</a>
        </div>
    </div>

    <div class="container">
        <a href="superadmin_dashboard.php" class="btn-back">← Kembali ke Dashboard</a>

        <div class="monitoring-section">
            <div class="section-header">
                <div class="section-title">Daftar Pengguna Sistem</div>
                <a href="superadmin_create_user.php" class="btn-add">➕ Tambah User</a>
            </div>

            <form method="GET" class="filter-form">
                <input type="text" name="search" placeholder="Cari username atau role..." value="<?php echo htmlspecialchars($search); ?>">
                <button type="submit" class="btn-filter">Cari</button>
                <?php if($search): ?><a href="superadmin_list_user.php" class="reset-filter">Reset</a><?php endif; ?>
            </form>

            <div class="table-responsive">
                <table width="100%">
                    <thead>
                        <tr>
                            <th width="10%">ID</th>
                            <th width="40%">Username</th>
                            <th width="30%">Role (Jabatan)</th>
                            <th width="20%">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (mysqli_num_rows($result) > 0): ?>
                            <?php while ($row = mysqli_fetch_assoc($result)) { ?>
                            <tr>
                                <td style="color:#999;">#<?php echo $row['id']; ?></td>
                                <td><strong><?php echo htmlspecialchars($row['username']); ?></strong></td>
                                <td>
                                    <span class="badge role-<?php echo $row['role']; ?>">
                                        <?php echo strtoupper($row['role']); ?>
                                    </span>
                                </td>
                                <td>
                                    <a href="superadmin_edit_user.php?id=<?php echo $row['id']; ?>" class="btn-edit">Edit</a>
                                    <a href="superadmin_delete_user.php?id=<?php echo $row['id']; ?>" class="btn-delete" onclick="return confirm('Yakin ingin menghapus user ini?');">Hapus</a>
                                </td>
                            </tr>
                            <?php } ?>
                        <?php else: ?>
                            <tr><td colspan="4" style="text-align:center; padding:30px; color:#999;">Tidak ada user ditemukan.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>

                <div class="pagination">
                    <?php 
                        $link_search = ($search) ? "&search=$search" : "";
                    ?>
                    <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                        <a href="?page=<?php echo $i . $link_search; ?>" class="page-link <?php echo ($i == $page) ? 'active' : ''; ?>"><?php echo $i; ?></a>
                    <?php endfor; ?>
                </div>

            </div>
        </div>
    </div>

</body>
</html>