<?php
// File: superadmin/superadmin_view_project.php

require_once('../db.php'); 
include 'auth_check.php';
require_role(['superadmin']); 

if (!isset($_GET['id'])) {
    header("Location: superadmin_list_project.php");
    exit;
}
$project_id = (int)$_GET['id'];

// 1. Ambil Detail Project
$sql_proj = "SELECT * FROM projects WHERE project_id = ?";
$stmt = $conn->prepare($sql_proj);
$stmt->bind_param("i", $project_id);
$stmt->execute();
$project = $stmt->get_result()->fetch_assoc();

if (!$project) die("Project tidak ditemukan.");

// 2. Ambil Employer
$employers = [];
$q_emp = mysqli_query($conn, "SELECT u.username FROM users u JOIN employer_projects ep ON u.id = ep.employer_id WHERE ep.project_id = $project_id");
while ($r = mysqli_fetch_assoc($q_emp)) $employers[] = $r['username'];

// 3. Ambil Member
$members = [];
$q_mem = mysqli_query($conn, "SELECT u.username FROM users u JOIN member_projects mp ON u.id = mp.member_id WHERE mp.project_id = $project_id");
while ($r = mysqli_fetch_assoc($q_mem)) $members[] = $r['username'];

// 4. Ambil Tugas dalam Project ini
$tasks = [];
$sql_task = "SELECT t.*, m.username as member_name FROM tasks t JOIN users m ON t.assigned_to = m.id WHERE t.project_id = ? ORDER BY t.id DESC";
$stmt_task = $conn->prepare($sql_task);
$stmt_task->bind_param("i", $project_id);
$stmt_task->execute();
$res_task = $stmt_task->get_result();
while ($row = $res_task->fetch_assoc()) $tasks[] = $row;
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <title>Detail Project: <?php echo htmlspecialchars($project['project_name']); ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Poppins', sans-serif; background: #f4f6f9; padding: 40px; color: #333; }
        .container { max-width: 900px; margin: 0 auto; }
        
        .card { background: white; padding: 30px; border-radius: 15px; box-shadow: 0 5px 20px rgba(0,0,0,0.05); margin-bottom: 30px; border-top: 5px solid #FF9800; }
        
        h1 { margin: 0 0 10px 0; font-size: 28px; color: #333; }
        .subtitle { color: #666; font-size: 14px; margin-bottom: 20px; }
        
        .info-box { background: #fff8e1; padding: 15px; border-radius: 8px; border: 1px solid #ffecb3; margin-bottom: 20px; }
        
        h3 { border-bottom: 2px solid #eee; padding-bottom: 10px; margin-bottom: 15px; font-size: 18px; }
        
        /* TEAM BADGES */
        .badge { padding: 5px 10px; border-radius: 4px; font-size: 12px; font-weight: 600; display: inline-block; margin-right: 5px; margin-bottom: 5px; }
        .badge-emp { background: #e3f2fd; color: #1565C0; border: 1px solid #bbdefb; }
        .badge-mem { background: #fff3e0; color: #EF6C00; border: 1px solid #ffe0b2; }

        /* TASK TABLE */
        table { width: 100%; border-collapse: collapse; font-size: 14px; }
        th { background: #333; color: white; padding: 10px; text-align: left; }
        td { padding: 10px; border-bottom: 1px solid #eee; }
        
        .btn-back { text-decoration: none; color: #666; font-weight: 600; display: flex; align-items: center; gap: 5px; margin-bottom: 20px; }
        .btn-back:hover { color: #000; }
        
        .status-completed { color: green; font-weight: bold; }
        .status-pending { color: orange; font-weight: bold; }
        .status-in_progress { color: blue; font-weight: bold; }
    </style>
</head>
<body>

<div class="container">
    <a href="superadmin_list_project.php" class="btn-back">← Kembali ke Daftar Project</a>

    <div class="card">
        <h1>📂 <?php echo htmlspecialchars($project['project_name']); ?></h1>
        <p class="subtitle">Detail Informasi Project</p>

        <div class="info-box">
            <strong>Deskripsi:</strong><br>
            <?php echo nl2br(htmlspecialchars($project['description'])); ?>
        </div>

        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 20px;">
            <div>
                <h3>👔 Employer (PJ)</h3>
                <?php if (empty($employers)): ?>
                    <span style="color:#999">- Tidak ada -</span>
                <?php else: ?>
                    <?php foreach($employers as $e) echo "<span class='badge badge-emp'>$e</span>"; ?>
                <?php endif; ?>
            </div>
            <div>
                <h3>👷 Member (Tim)</h3>
                <?php if (empty($members)): ?>
                    <span style="color:#999">- Tidak ada -</span>
                <?php else: ?>
                    <?php foreach($members as $m) echo "<span class='badge badge-mem'>$m</span>"; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="card" style="border-top-color: #E91E63;">
        <h3>📝 Daftar Tugas dalam Project Ini</h3>
        
        <?php if (empty($tasks)): ?>
            <p style="text-align:center; color:#999;">Belum ada tugas di project ini.</p>
        <?php else: ?>
            <table>
                <thead>
                    <tr>
                        <th>Judul Tugas</th>
                        <th>Penerima</th>
                        <th>Deadline</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($tasks as $t): 
                        $st = strtolower($t['status']); if(!$st)$st='pending';
                    ?>
                    <tr>
                        <td><?php echo htmlspecialchars($t['title']); ?></td>
                        <td><?php echo htmlspecialchars($t['member_name']); ?></td>
                        <td style="color:#d32f2f;"><?php echo $t['due_date']; ?></td>
                        <td class="status-<?php echo $st; ?>"><?php echo strtoupper(str_replace('_',' ',$st)); ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>

</div>

</body>
</html>