<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Session;

class BcAuthMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
   public function handle(Request $request, Closure $next)
    {
        // Allow public auth routes
        if (
            $request->routeIs('login') ||
            $request->routeIs('azure.redirect') ||
            $request->routeIs('azure.callback')
        ) {
            return $next($request);
        }

        // Require delegated BC login
        if (
            !session()->has('user') ||
            !session()->has('bc_token')
        ) {
            Session::flush();
            return redirect()->route('login');
        }

        return $next($request);
    }
}
