<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Company extends Model
{
    protected $fillable = ['code','name'];

    public function users(): BelongsToMany
    {
        // pivot: company_user (company_id, user_id)
        return $this->belongsToMany(User::class, 'company_user', 'company_id', 'user_id');
    }
}