<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Jalankan migrasi.
     */
    public function up(): void
    {
        Schema::create('requests_log', function (Blueprint $table) {
            $table->id();
            
            // Relasi ke tabel ItemRequests (boleh duplikat)
            $table->unsignedBigInteger('item_request_id')->nullable();
            $table->foreign('item_request_id')
                  ->references('id')
                  ->on('item_requests')
                  ->onDelete('set null'); // bisa ubah ke cascade kalau mau ikut terhapus

            // Jenis request (contoh: ExtDate, ChangePrice, dll)
            $table->string('request_type');

            // Action (hanya 2: create / update)
            $table->enum('action', ['create', 'update']);

            // Siapa yang melakukan request
            $table->string('requestby');

            $table->timestamps(); // created_at & updated_at
        });
    }

    /**
     * Rollback migrasi.
     */
    public function down(): void
    {
        Schema::dropIfExists('requests_log');
    }
};
