@extends('layouts.app')
@section('title','Admin — Users Management')

@push('styles')
<style>
    .pill { border-radius: 999px; }
    .card-rounded { border-radius: 1rem; }
</style>
@endpush

@section('content')
<div class="container py-4">

    {{-- ✅ Alert Section --}}
    @if(session('success'))
        <div class="alert alert-success"><i class="fa fa-check-circle me-1"></i>{{ session('success') }}</div>
    @endif
    @if($errors->any())
        <div class="alert alert-danger"><i class="fa fa-triangle-exclamation me-1"></i>{{ $errors->first() }}</div>
    @endif

    {{-- ✅ Users Section --}}
    <a id="users"></a>

    {{-- Add / Upsert User --}}
    <div class="card card-rounded mb-3">
        <div class="card-header bg-primary text-white">
            <i class="fa fa-user-plus me-1"></i> Add / Upsert User
        </div>
        <div class="card-body">
            <form class="row g-3" method="POST" action="{{ route('admin.users.store') }}">
                @csrf
                <div class="col-md-3">
                    <label class="form-label">Name</label>
                    <input name="name" class="form-control" placeholder="Full name" required>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Email</label>
                    <input name="email" type="email" class="form-control" placeholder="user@yourtenant.onmicrosoft.com" required>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Notification Email(s) <small class="text-muted">(optional)</small></label>
                    <input name="notify_email" type="text" class="form-control"
                           placeholder="alt@company.com, second@company.com">
                    <div class="form-text">Separate multiple with comma/semicolon/space.</div>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Role</label>
                    <select name="role_id" class="form-select">
                        <option value="">(none)</option>
                        @foreach($roles as $r)
                            <option value="{{ $r->id }}">{{ $r->code }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Companies</label>
                    <select name="company_ids[]" class="form-select" multiple>
                        @foreach($companies as $c)
                            <option value="{{ $c->id }}">{{ $c->code }} — {{ $c->name }}</option>
                        @endforeach
                    </select>
                    <div class="form-text">Hold Ctrl/Cmd to pick multiple.</div>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Company Codes (opt)</label>
                    <input name="company_codes" class="form-control" placeholder="e.g. CI, TBI">
                </div>
                <div class="col-12">
                    <button class="btn btn-primary"><i class="fa fa-save me-1"></i> Save</button>
                </div>
            </form>
            <div class="small text-muted mt-2">
                Users log in via Microsoft; adding them here just pre-creates the row and assigns a role.
            </div>
        </div>
    </div>

    {{-- ✅ Users Table --}}
    <div class="card card-rounded">
        <div class="card-header bg-secondary text-white">
            <i class="fa fa-users me-1"></i> Users
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Notify Email</th>
                            <th>Company</th>
                            <th>Role</th>
                            <th>Change Role</th>
                            <th>Edit</th>
                            <th style="width:70px">Del</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($users as $u)
                            <tr>
                                <td>{{ $u->id }}</td>
                                <td>{{ $u->name }}</td>
                                <td class="small text-muted">{{ $u->email }}</td>
                                <td class="small text-muted">{{ $u->notify_email ?: '—' }}</td>
                                <td class="small">
                                    @php $codes = $u->companies()->pluck('code')->all(); @endphp
                                    {{ empty($codes) ? '—' : implode(', ', $codes) }}
                                </td>
                                <td><span class="badge bg-dark">{{ $u->role?->code ?? '—' }}</span></td>

                                {{-- Change Role --}}
                                <td>
                                    <form class="d-flex gap-2" method="POST" action="{{ route('admin.users.updateRole',$u) }}">
                                        @csrf
                                        <select name="role_id" class="form-select form-select-sm" style="max-width:200px">
                                            <option value="">(none)</option>
                                            @foreach($roles as $r)
                                                <option value="{{ $r->id }}" {{ $u->role_id===$r->id?'selected':'' }}>
                                                    {{ $r->code }}
                                                </option>
                                            @endforeach
                                        </select>
                                        <button class="btn btn-primary btn-sm"><i class="fa fa-save"></i></button>
                                    </form>
                                </td>

                                {{-- Inline Edit --}}
                                <td>
                                    <form class="d-flex flex-wrap gap-2 align-items-center"
                                          method="POST" action="{{ route('admin.users.update', $u) }}">
                                        @csrf
                                        @method('PATCH')

                                        <input name="name" class="form-control form-control-sm" style="max-width:180px"
                                               value="{{ old('name',$u->name) }}">

                                        <input name="notify_email" class="form-control form-control-sm" style="max-width:240px"
                                               placeholder="alt1@x.com, alt2@x.com"
                                               value="{{ old('notify_email',$u->notify_email) }}">

                                        <select name="company_ids[]" class="form-select form-select-sm" style="max-width:260px" multiple>
                                            @foreach($companies as $c)
                                                <option value="{{ $c->id }}" {{ $u->companies->contains('id', $c->id) ? 'selected' : '' }}>
                                                    {{ $c->code }} — {{ $c->name }}
                                                </option>
                                            @endforeach
                                        </select>

                                        <input name="company_codes" class="form-control form-control-sm" style="max-width:200px"
                                               placeholder="CI, TBI" value="{{ old('company_codes', $u->company_codes) }}">

                                        <select name="role_id" class="form-select form-select-sm" style="max-width:180px">
                                            <option value="">(none)</option>
                                            @foreach($roles as $r)
                                                <option value="{{ $r->id }}" {{ $u->role_id===$r->id?'selected':'' }}>
                                                    {{ $r->code }}
                                                </option>
                                            @endforeach
                                        </select>

                                        <button class="btn btn-primary btn-sm"><i class="fa fa-save"></i></button>
                                    </form>
                                </td>

                                {{-- Delete --}}
                                <td>
                                    <form method="POST" action="{{ route('admin.users.destroy',$u) }}"
                                          onsubmit="return confirm('Delete this user?');">
                                        @csrf
                                        @method('DELETE')
                                        <button class="btn btn-outline-danger btn-sm">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                {{ $users->withQueryString()->links() }}
            </div>
        </div>
    </div>
</div>
@endsection
