<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Services\BusinessCentralService;
use App\Models\BudgetButcher;

class BudgetItemController extends Controller
{
    /**
     * ============================================================
     * 1. Ambil Budget Lost dari Business Central
     * ============================================================
     */
    public function getBudgetLost()
    {
        // Buat instance service (ini butuh session saat dipanggil user normal)
        $bcService = new BusinessCentralService();
        $response  = $bcService->getBudgetLost();

        return response()->json([
            "summary" => $response['summary'] ?? [],
            "raw"     => $response['raw'] ?? []
        ]);
    }


    /**
     * ============================================================
     * 2. Wrapper Khusus Scheduler (TANPA mengubah fungsi utama)
     * ============================================================
     * Scheduler tidak punya session, maka kita set session manual.
     */
public function storeRawToDatabaseFromScheduler()
{
    // Tentukan company default untuk scheduler
    $company = 'Regent'; // atau 'HIN'

    // Inject manual ke Service tanpa session
    $bcService = new BusinessCentralService($company);

    try {
        $response = $bcService->getBudgetLost();
    } catch (\Throwable $e) {
        \Log::error("Scheduler BC API error: " . $e->getMessage());
        return;
    }

    $rawItems = $response['raw'] ?? [];

    if (empty($rawItems)) {
        \Log::warning("Scheduler: rawItems empty");
        return;
    }

    DB::table('budget_butcher')->truncate();

    foreach ($rawItems as $row) {
        BudgetButcher::create([
            "LocationCode"      => $row['LocationCode'] ?? null,
            "PostingDate"       => $row['PostingDate'] ?? null,
            "CostAmountActual"  => $row['CostAmountActual'] ?? 0,
            "ItemNo"            => $row['ItemNo'] ?? null,
            "Description"       => $row['Description'] ?? null,
        ]);
    }

    \Log::info("Scheduler: inserted " . count($rawItems) . " rows");
}

}
