<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('item_request_attachments', function (Blueprint $t) {
            $t->id();
            $t->foreignId('item_request_id')->constrained()->cascadeOnDelete();
            $t->foreignId('uploader_user_id')->nullable()->constrained('users')->nullOnDelete();
            $t->string('original_name');
            $t->string('path');                 // storage path on disk
            $t->string('mime')->nullable();
            $t->unsignedBigInteger('size');     // bytes
            $t->timestamps();

            $t->index('item_request_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('item_request_attachments');
    }
};