
<?php $__env->startSection('content'); ?>
    <!-- Pastry Recipes Blade - Refactored JS (template literals, modular) -->
    <div class="container py-4" style="background:#FFF8F0; border-radius:14px;">
        <div class="d-flex align-items-center justify-content-between mb-4">
            <div>
                <h2 class="fw-bold mb-0" style="color:#183647;">Butcher Recipes</h2>
                <div class="small text-muted">Production · Butcher Department</div>
            </div>

            <div class="d-flex gap-2 align-items-center">
                <input id="searchInput" class="form-control form-control-sm" placeholder="Search recipe..."
                    style="min-width:260px; background:#fff; border-radius:12px;" />
                <button id="refreshBtn" class="btn btn-sm" title="Refresh"
                    style="background:#F2E6DA; color:#5a3e2b; border-radius:10px;">⟳</button>
            </div>
        </div>

        <div class="table-responsive shadow-sm rounded-3 bg-white p-3" style="overflow-x:auto;">
            <table class="table mb-0 align-middle" id="recipesTable" style="font-size:13px;">
                <thead style="background:#FAEBD7; border-radius:8px; white-space:nowrap;">
                    <tr>
                        <th style="width:4%">No</th>
                        <th style="width:20%">Recipe</th>
                        <th style="width:6%">Min<br>Stock</th>
                        <th style="width:6%">Max<br>Stock</th>
                        <th style="width:6%">TO</th>
                        <th style="width:10%">QtyTO<br>Assemble</th>
                        <th style="width:12%">Stock</th>
                        <th style="width:12%">Cost</th>
                        <th style="width:14%">Shipment Info</th>
                        <th style="width:10%">Outstanding AO</th>
                        <th style="width:10%">Status</th>
                        <th style="width:12%" class="text-end">Actions</th>
                    </tr>
                </thead>
                <tbody id="recipesTbody">
                    <!-- Rows injected by JS -->
                </tbody>
            </table>
            <div id="pagination" class="mt-2"></div>
        </div>

    </div>
    <!-- ============================= -->
    <!-- 🍰 AO MODAL -->
    <!-- ============================= -->
    <div class="modal fade" id="aoModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header" style="background:#FFD6A5;">
                    <h5 class="modal-title fw-semibold">Create Assembly Order (AO)</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="aoForm">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" id="ao_recipe_id">
                        <!-- Header Section -->
                        <div class="row g-3 mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Recipe Description</label>
                                <input type="text" id="ao_recipe_name" class="form-control" readonly>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Item No</label>
                                <input type="text" id="ao_item_no" class="form-control" readonly>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Base Unit</label>
                                <input type="text" id="ao_uom" class="form-control" readonly>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Quantity</label>
                            <input type="number" id="ao_qty" class="form-control text-start" min="0.1"
                                step="any" value="1" inputmode="decimal">
                        </div>

                        <!-- Line Section -->
                        <div class="border rounded p-3 bg-light mb-2">
                            <div class="fw-semibold mb-2">Material Requirements</div>
                            <div id="aoLines" class="table-responsive">
                                <table class="table table-sm align-middle mb-0">
                                    <thead>
                                        <tr>
                                            <th>Material</th>
                                            <th>Needed</th>
                                            <th>Inventory</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody id="aoLineBody">
                                        <tr>
                                            <td colspan="4" class="text-muted text-center small">Enter quantity to
                                                calculate materials...</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        <!-- Warning -->
                        <div id="aoWarning" class="text-danger small mb-2" style="display:none;">
                            ⚠️ Insufficient stock to produce this quantity.
                        </div>

                        <!-- Submit -->
                        <div class="d-grid">
                            <button id="aoSubmit" class="btn" style="background:#FFB84D; color:white;" type="submit"
                                disabled>
                                Create AO
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- TO Modal -->
    <!-- Create Transfer Order Modal -->
    <div class="modal fade" id="toModal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content border-0 shadow-sm" style="border-radius: 1rem;">

                <!-- Header -->
                <div class="modal-header text-white"
                    style="background:#9FCBE6; border-top-left-radius:1rem; border-top-right-radius:1rem;">
                    <h5 class="modal-title fw-semibold">Create Transfer Order (TO)</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>

                <!-- Body -->
                <div class="modal-body p-4">
                    <form id="toForm">

                        <!-- ===== HEADER SECTION ===== -->
                        <div class="border rounded-3 p-3 mb-4 bg-light">
                            <h6 class="fw-semibold text-primary mb-3">Header Information</h6>

                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">No. Series</label>
                                    <select id="to_noSeries" name="header[noSeries]" class="form-select">
                                        <option value="TO.RBC" selected>RBC</option>
                                        <option value="TO.CI">CI</option>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">Transfer Spec</label>
                                    <select id="to_transSpec" name="header[transSpec]" class="form-select">
                                        <option value="ST. ORDER">Transfer Internal Business Unit</option>
                                        <option value="ST.EXT BU">Transfer Antara Business Unit</option>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">Business Unit</label>
                                    <select id="to_businessUnit" name="header[businessUnit]" class="form-select"
                                        disabled>
                                        <option value="RBC" selected>Regent Bali Canggu</option>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">Department</label>
                                    <input type="text" id="to_department" name="header[department]"
                                        class="form-control" value="8430" readonly>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">Transfer From</label>
                                    <select id="to_transferFrom" name="header[transferFrom]" class="form-select">
                                        <option value="CI.1010" selected>Food Central</option>
                                    </select>
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label fw-semibold">Transfer To</label>
                                    <select id="to_transferTo" name="header[transferTo]" class="form-select">
                                        <option value="CI.1011" selected>Butcher</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- ===== ITEM SECTION ===== -->
                        <div class="border rounded-3 p-3 bg-light">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h6 class="fw-semibold text-primary mb-0">Item Lines</h6>
                                <button type="button" class="btn btn-sm btn-outline-primary fw-semibold"
                                    id="addItemBtn">
                                    <i class="bi bi-plus-circle me-1"></i> Add Item
                                </button>
                            </div>

                            <div id="itemContainer">
                                <!-- Dynamic items will be added here -->
                            </div>
                        </div>

                        <!-- Submit -->
                        <div class="d-grid mt-4">
                            <button class="btn text-white fw-semibold" type="submit" style="background-color:#7DC5E3;">
                                <i class="bi bi-arrow-repeat me-1"></i> Create TO
                            </button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>


    <style>
        /* Pastel + mockup-like table styling */
        body {
            background: #F0FAFF;
        }

        #recipesTable thead th {
            border-top-left-radius: 8px;
            border-top-right-radius: 8px;
        }

        .recipe-row {
            transition: transform .18s ease, box-shadow .18s ease, background .15s ease;
        }

        .recipe-row:hover {
            transform: translateY(-4px);
            background: #FFF7EE;
        }

        .status-ready {
            background: #E6F9EF;
            color: #0f5132;
            padding: .4rem .6rem;
            border-radius: 8px;
            display: inline-block;
        }

        .status-need {
            background: #FFF1F0;
            color: #842029;
            padding: .4rem .6rem;
            border-radius: 8px;
            display: inline-block;
        }

        .ingredients-card {
            overflow: hidden;
            transition: max-height .28s cubic-bezier(.2, .8, .2, 1), opacity .2s ease;
            max-height: 0;
            opacity: 0;
        }

        .ingredients-card.open {
            max-height: 800px;
            opacity: 1;
        }

        .ingredients-inner {
            background: #FFF8F0;
            border: 1px solid #FAEBD7;
            border-radius: 10px;
            padding: 12px;
            box-shadow: 0 6px 18px rgba(15, 23, 42, 0.04);
        }

        .progress-small {
            height: 10px;
            border-radius: 8px;
            overflow: hidden;
            background: #FFF3EB;
        }

        .progress-bar-soft {
            height: 10px;
            border-radius: 8px;
        }

        .btn-ao {
            background: #FFB84D;
            color: white;
            border-radius: 8px;
            padding: .35rem .7rem;
            border: none;
        }

        .btn-to {
            background: #6FB3D2;
            color: white;
            border-radius: 8px;
            padding: .35rem .7rem;
            border: none;
        }

        .ingredients-grid {
            display: flex;
            gap: 18px;
            flex-wrap: wrap;
        }

        .ingredients-col {
            flex: 1 1 300px;
        }

        .small-muted {
            color: #6b7280;
        }

        @media (max-width: 768px) {
            .ingredients-grid {
                flex-direction: column;
            }

            #searchInput {
                min-width: 160px
            }
        }
    </style>

    <script>
        document.addEventListener('DOMContentLoaded', async () => {
            const qs = s => document.querySelector(s);
            const qsa = s => Array.from(document.querySelectorAll(s));

            // =============================
            // Skeleton Loader
            // =============================
            function showSkeleton() {
                const skeletonRows = Array(5).fill().map(() => `
<tr>
    <td colspan="12">
      <div class="d-flex align-items-center gap-3 p-2">
        <div class="skeleton-box" style="width:60px; height:20px;"></div>
        <div class="skeleton-box flex-grow-1" style="height:20px;"></div>
        <div class="skeleton-box" style="width:80px; height:20px;"></div>
      </div>
    </td>
</tr>`).join('');
                qs('#recipesTbody').innerHTML = skeletonRows;
            }

            function hideSkeleton() {
                qsa('.skeleton-box').forEach(el => el.remove());
            }

            // =============================
            // Fetch BOM Data
            // =============================
            async function fetchBOMData() {
                showSkeleton();
                try {
                    const res = await fetch(`<?php echo e(route('bc.bom-with-stock')); ?>`);
                    if (!res.ok) throw new Error(`HTTP ${res.status}`);
                    const data = await res.json();
                    if (data.status === 'success') {
                        window._allRecipeData = data.items;
                        currentPage = 1;
                        renderPaginatedTable(window._allRecipeData);
                    } else {
                        qs('#recipesTbody').innerHTML =
                            `<tr><td colspan="12" class="text-center text-danger">Failed to load data</td></tr>`;
                    }
                } catch (e) {
                    qs('#recipesTbody').innerHTML =
                        `<tr><td colspan="12" class="text-center text-danger">Error loading data</td></tr>`;
                    console.error(e);
                } finally {
                    hideSkeleton();
                }
            }

            // =============================
            // Helper
            // =============================
            function percent(stock, cap) {
                return cap > 0 ? Math.round((stock / cap) * 100) : 0;
            }

            function safeNumber(val) {
                const num = Number(val);
                return isNaN(num) ? 0 : parseFloat(num.toFixed(10));
            }

            function ingredientDropdownHtml(ingredients) {
                if (!ingredients || ingredients.length === 0)
                    return `<div class="p-2 text-muted">No ingredients</div>`;
                return `<div class="p-2 border rounded bg-light">
<table class="table table-sm mb-0">
  <thead><tr><th>Material</th><th>Qty</th><th>UoM</th><th>Inventory</th></tr></thead>
  <tbody>${ingredients.map(i=>`
        <tr>
          <td>${i.BOM}~${i.BOM_Description}</td>
          <td>${i.Quantity}</td>
          <td>${i.Uom_BOM}</td>
          <td>${i.Inventory ?? 0}</td>
        </tr>`).join('')}
  </tbody>
</table>
</div>`;
            }

            function getRecipeStatus(r) {
                const inv = parseFloat(r.Inventory ?? 0);
                const min = parseFloat(r.Minimum_Stock ?? 0);
                const toTotal = safeNumber(r.to_total_qty ?? 0);
                const hasTO = r.statusTO === true;

                if (!hasTO) return 'Standby';
                if (inv >= toTotal) return 'Need To Transfer';
                return 'Need To Assemble';
            }

            // =============================
            // Quantity Assemble
            // =============================
            function computeQuantityAssemble(r) {
                const toTotal = safeNumber(r.to_total_qty ?? 0);
                const inv = safeNumber(r.Inventory ?? 0);
                const maxStock = safeNumber(r.Maximum_Inventory ?? 0);
                const minStock = safeNumber(r.Minimum_Stock ?? 0);
                const outstandingQty = safeNumber(r.Outstanding_AO_Qty ?? 0);

                const bufferStock = maxStock > 0 ? maxStock : (minStock > 0 ? minStock : 0);
                let toRemaining = toTotal - inv;
                if (toRemaining <= 0) return 0;

                let qty = toRemaining + bufferStock;
                qty = qty - outstandingQty;
                return qty < 0 ? 0 : qty;
            }

            function renderShipmentInfo(to_list) {
                if (!to_list || to_list.length === 0) return `<div class="text-muted small">-</div>`;
                const sorted = [...to_list].sort((a, b) => new Date(a.shipmentDate) - new Date(b.shipmentDate));
                return `<div class="small">${sorted.map(t=>`${t.shipmentDate.split('-').reverse().join('-')} : ${t.quantity}`).join('<br>')}</div>`;
            }

            // =============================
            // Render Row (UPDATED: add Cost)
            // =============================
            function renderRow(r, index) {
                const status = getRecipeStatus(r);
                const statusColor = (status === 'Need To Assemble' || status === 'Need To Transfer') ?
                    'status-need' :
                    (status === 'Standby' ? 'status-ready' : 'status-need');

                const p = percent(r.Inventory ?? 0, r.Maximum_Inventory ?? 0);
                const minStock = r.Minimum_Stock ?? 0;
                const maxStock = r.Maximum_Inventory ?? 0;
                const toTotal = r.to_total_qty ?? 0;
                const qtyAssemble = computeQuantityAssemble(r);
                const outstandingAO = r.Outstanding_AO ?? '-';
                const outstandingAOQty = r.Outstanding_AO_Qty ?? 0;

                // NEW FIELD: COST
                const cost = safeNumber(r.Standart_Cost ?? 0);
                return `
<tr class="recipe-row" data-id="${r.BOM_Parent}">
    <td>${index}</td>
    <td>
        <div class="fw-semibold">${r.Description_BOM}</div>
        <div class="small text-muted">${r.BOM_Parent}</div>
        <a href="#" class="small view-ings" data-id="${r.BOM_Parent}">Show Materials ▾</a>
    </td>
    <td class="text-nowrap">${minStock}</td>
    <td class="text-nowrap">${maxStock}</td>
    <td class="text-nowrap">${toTotal}</td>
    <td class="text-nowrap">${qtyAssemble}</td>

    <!-- STOCK -->
    <td>
        <div class="d-flex align-items-center gap-3">
            <div class="fw-semibold">${r.Inventory ?? 0}</div>
            <div style="flex:1">
                <div class="progress-small">
                    <div class="progress-bar-soft" style="width:${p}%; background:${p>70?'#90EEA2':(p<=50?'#FFD58A':'#FCA5A5')};"></div>
                </div>
            </div>
        </div>
    </td>

    <!-- NEW COLUMN: COST -->
    <td class="text-nowrap">${cost.toLocaleString()}</td>

    <td class="text-nowrap">${renderShipmentInfo(r.to_list)}</td>
    <td class="text-nowrap">${outstandingAO} <span class="small text-muted">(${outstandingAOQty})</span></td>
    <td class="text-nowrap"><span class="${statusColor}">${status}</span></td>
    <td class="text-end text-nowrap">
        <button class="btn-ao me-2" data-id="${r.BOM_Parent}" data-qa="${qtyAssemble}">Assembly Order</button>
    </td>
</tr>
<tr class="ing-row" style="display:none;"><td colspan="12">${ingredientDropdownHtml(r.Item_Operation)}</td></tr>`;
            }

            // =============================
            // Pagination + Sorting
            // =============================
            const PAGE_SIZE = 50;
            let currentPage = 1;
            let currentSort = {
                key: 'no',
                asc: true
            };

            function renderPaginatedTable(data) {
                if (!data || data.length === 0) {
                    qs('#recipesTbody').innerHTML =
                        `<tr><td colspan="12" class="text-center text-muted py-4">No recipes found.</td></tr>`;
                    qs('#pagination').innerHTML = '';
                    return;
                }

                const sorted = [...data].sort((a, b) => {
                    if (a.statusTO && !b.statusTO) return -1;
                    if (!a.statusTO && b.statusTO) return 1;

                    const key = currentSort.key;
                    let valA, valB;

                    if (key === 'no') {
                        valA = data.indexOf(a) + 1;
                        valB = data.indexOf(b) + 1;
                    } else if (key === 'recipe') {
                        valA = a.Description_BOM ?? '';
                        valB = b.Description_BOM ?? '';
                    } else if ([
                            'minStock', 'maxStock', 'to', 'qtyAssemble',
                            'stock', 'outstandingAO', 'cost','status'
                        ].includes(key)) {

                        const mapKey = {
                            minStock: 'Minimum_Stock',
                            maxStock: 'Maximum_Inventory',
                            to: 'to_total_qty',
                            qtyAssemble: 'qtyAssemble',
                            stock: 'Inventory',
                            outstandingAO: 'outstanding_ao',
                            cost: 'Standart_Cost',
                            status: 'status', 
                        };

                        if (key === 'qtyAssemble') {
                            valA = computeQuantityAssemble(a);
                            valB = computeQuantityAssemble(b);
                        } else {
                            valA = safeNumber(a[mapKey[key]] ?? 0);
                            valB = safeNumber(b[mapKey[key]] ?? 0);
                        }
                    } else if (key === 'status') {
                        const priority = {
                            'Need To Assemble': 1,
                            'Need To Transfer': 2,
                            'Standby': 3
                        };
                        valA = priority[getRecipeStatus(a)];
                        valB = priority[getRecipeStatus(b)];
                    }

                    if (valA < valB) return currentSort.asc ? -1 : 1;
                    if (valA > valB) return currentSort.asc ? 1 : -1;
                    return 0;
                });

                const totalPages = Math.ceil(sorted.length / PAGE_SIZE);
                const start = (currentPage - 1) * PAGE_SIZE;
                const end = start + PAGE_SIZE;
                const pageData = sorted.slice(start, end);
                const html = pageData.map((r, i) => renderRow(r, start + i + 1)).join('');

                const tbody = qs('#recipesTbody');
                tbody.classList.remove('fade-in');
                tbody.classList.add('fade-out');

                setTimeout(() => {
                    tbody.innerHTML = html;
                    tbody.classList.remove('fade-out');
                    tbody.classList.add('fade-in');
                    attachListeners(sorted);
                    renderPaginationControls(totalPages);
                }, 150);
            }

            // =============================
            // SORT HEADERS (UPDATED: ADD COST)
            // =============================
            function attachSortListeners() {
                const headers = [{
                        selector: 'th:nth-child(1)',
                        key: 'no'
                    },
                    {
                        selector: 'th:nth-child(2)',
                        key: 'recipe'
                    },
                    {
                        selector: 'th:nth-child(3)',
                        key: 'minStock'
                    },
                    {
                        selector: 'th:nth-child(4)',
                        key: 'maxStock'
                    },
                    {
                        selector: 'th:nth-child(5)',
                        key: 'to'
                    },
                    {
                        selector: 'th:nth-child(6)',
                        key: 'qtyAssemble'
                    },
                    {
                        selector: 'th:nth-child(7)',
                        key: 'stock'
                    },

                    // NEW SORT HEADER FOR COST
                    {
                        selector: 'th:nth-child(8)',
                        key: 'cost'
                    },
                    
                    {
                        selector: 'th:nth-child(10)',
                        key: 'outstandingAO'
                    },
                    {
                        selector: 'th:nth-child(11)',
                        key: 'cost'
                    }
                ];

                headers.forEach(h => {
                    const el = qs(h.selector);
                    if (!el) return;

                    el.style.cursor = 'pointer';
                    el.addEventListener('click', () => {
                        if (currentSort.key === h.key) {
                            currentSort.asc = !currentSort.asc;
                        } else {
                            currentSort.key = h.key;
                            currentSort.asc = true;
                        }

                        headers.forEach(h2 => {
                            const el2 = qs(h2.selector);
                            el2.innerHTML = el2.textContent.replace(' ↑', '').replace(
                                ' ↓', '');
                            if (currentSort.key === h2.key) {
                                el2.innerHTML += currentSort.asc ? ' ↑' : ' ↓';
                            }
                        });

                        renderPaginatedTable(window._filteredData || window._allRecipeData);
                    });
                });
            }

            // =========================
            // Pagination
            // =========================
            function renderPaginationControls(totalPages) {
                const pagination = qs('#pagination');
                if (!pagination) return;
                if (totalPages <= 1) {
                    pagination.innerHTML = '';
                    return;
                }

                let html = `<ul class="pagination justify-content-center">`;
                html += `<li class="page-item ${currentPage === 1 ? 'disabled' : ''}">
            <a class="page-link" href="#" data-page="${currentPage - 1}">←</a></li>`;

                const range = [];
                for (let i = 1; i <= totalPages; i++) {
                    if (i === 1 || i === totalPages || (i >= currentPage - 1 && i <= currentPage + 1))
                        range.push(i);
                    else if (range[range.length - 1] !== '...')
                        range.push('...');
                }

                range.forEach(p => {
                    if (p === '...') {
                        html +=
                        `<li class="page-item disabled"><span class="page-link">...</span></li>`;
                    } else {
                        html += `<li class="page-item ${p === currentPage ? 'active' : ''}">
                    <a class="page-link" href="#" data-page="${p}">${p}</a></li>`;
                    }
                });

                html += `<li class="page-item ${currentPage === totalPages ? 'disabled' : ''}">
            <a class="page-link" href="#" data-page="${currentPage + 1}">→</a></li>`;
                html += `</ul>`;

                pagination.innerHTML = html;

                qsa('#pagination .page-link').forEach(btn => {
                    btn.addEventListener('click', e => {
                        e.preventDefault();
                        const page = parseInt(btn.dataset.page);
                        if (!page || page < 1 || page > totalPages || page === currentPage)
                            return;
                        currentPage = page;
                        renderPaginatedTable(window._filteredData || window._allRecipeData);
                    });
                });
            }

            // =========================
            // Search Filter
            // =========================
            qs('#searchInput')?.addEventListener('input', function() {
                const q = this.value.trim().toLowerCase();
                if (!window._allRecipeData) return;

                if (!q) {
                    window._filteredData = null;
                    currentPage = 1;
                    renderPaginatedTable(window._allRecipeData);
                    return;
                }

                window._filteredData = window._allRecipeData.filter(r =>
                    (r.Description_BOM ?? '').toLowerCase().includes(q) ||
                    (r.BOM_Parent ?? '').toLowerCase().includes(q)
                );

                currentPage = 1;
                renderPaginatedTable(window._filteredData);
            });

            // =========================
            // Attach Listeners
            // =========================
            function attachListeners(data) {
                qsa('.view-ings').forEach(a =>
                    a.addEventListener('click', e => {
                        e.preventDefault();
                        const row = a.closest('tr');
                        const next = row.nextElementSibling;
                        if (next && next.classList.contains('ing-row')) {
                            next.style.display = next.style.display === 'none' ? 'table-row' : 'none';
                        }
                    })
                );

                qsa('.btn-ao').forEach(btn => btn.addEventListener('click', () => {
                    const bomId = btn.getAttribute('data-id');
                    const recipe = data.find(x => x.BOM_Parent === bomId);
                    const suggestedQty = parseFloat(btn.dataset.qa) || 1;
                    openAOModal(recipe, suggestedQty);
                }));
            }

            // =========================
            // Modal AO
            // =========================
            let currentAORecipe = null;

            function openAOModal(recipe, suggestedQty) {
                const modal = new bootstrap.Modal(qs('#aoModal'));
                currentAORecipe = recipe;

                qs('#ao_recipe_id').value = recipe.BOM_Parent;
                qs('#ao_recipe_name').value = recipe.Description_BOM;
                qs('#ao_item_no').value = recipe.BOM_Parent;
                qs('#ao_uom').value = recipe.Uom_BOM_Parent || '-';

                const qty = parseFloat(suggestedQty) || 1;
                qs('#ao_qty').value = qty;

                renderAOLines(recipe, qty);
                modal.show();

                const qtyInput = qs('#ao_qty');
                qtyInput.oninput = () => {
                    let val = qtyInput.value.trim();
                    if (!/^\d*\.?\d*$/.test(val)) {
                        val = val.replace(/[^0-9.]/g, '');
                        qtyInput.value = val;
                    }
                    const newQty = parseFloat(val);
                    if (!isNaN(newQty) && newQty > 0) {
                        renderAOLines(recipe, newQty);
                    }
                };
            }

            // =========================
            // Render AO Lines
            // =========================
            function renderAOLines(recipe, qty) {
                const tbody = qs('#aoLineBody');
                const warning = qs('#aoWarning');
                const submitBtn = qs('#aoSubmit');

                if (!recipe.Item_Operation || recipe.Item_Operation.length === 0) {
                    tbody.innerHTML =
                        `<tr><td colspan="4" class="text-muted text-center small">No materials listed.</td></tr>`;
                    submitBtn.disabled = true;
                    warning.style.display = 'block';
                    return;
                }

                let hasInsufficient = false;

                const rows = recipe.Item_Operation.map(i => {
                    const baseQty = safeNumber(i.Quantity_Base ?? i.Quantity ?? 0);
                    const inv = safeNumber(i.Inventory ?? 0);
                    const needBase = baseQty * qty;
                    const enough = inv - needBase >= 0;

                    if (!enough) hasInsufficient = true;

                    const formatNum = n => parseFloat(n).toLocaleString('en-US', {
                        maximumFractionDigits: 3
                    });

                    return `
<tr>
    <td>${i.BOM_Description}</td>
    <td>${formatNum(needBase)} ${i.Base_UoM}</td>
    <td>${formatNum(inv)}</td>
    <td>
      <span class="badge ${enough ? 'bg-success-subtle text-success' : 'bg-danger-subtle text-danger'}">
        ${enough ? 'Sufficient' : 'Insufficient'}
      </span>
    </td>
</tr>`;
                }).join('');

                tbody.innerHTML = rows;
                submitBtn.disabled = hasInsufficient;
                warning.style.display = hasInsufficient ? 'block' : 'none';
            }

            // =========================
            // Submit AO
            // =========================
            if (qs('#aoForm')) {
                qs('#aoForm').addEventListener('submit', async e => {
                    e.preventDefault();

                    const qty = parseFloat(qs('#ao_qty').value);
                    if (!currentAORecipe || isNaN(qty) || qty <= 0) return;

                    const payload = {
                        itemNo: currentAORecipe.BOM_Parent,
                        quantity: qty,
                        postingDate: new Date().toISOString().split('T')[0],
                    };

                    Swal.fire({
                        title: 'Preparing your Assembly Order...',
                        html: `<div class="pastry-loader"><div class="dough-rise"></div><p class="mt-3 text-muted small">Making Your Order 🥩</p></div>`,
                        allowOutsideClick: false,
                        showConfirmButton: false,
                        background: '#fffbea',
                        customClass: {
                            popup: 'sweet-slim'
                        }
                    });

                    try {
                        const res = await fetch(`<?php echo e(route('bc.assembly-header.create')); ?>`, {
                            method: 'POST',
                            headers: {
                                'Accept': 'application/json',
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                            },
                            body: JSON.stringify(payload)
                        });

                        const text = await res.text();
                        let data = {};
                        try {
                            data = JSON.parse(text);
                        } catch {
                            throw new Error('Invalid response from server');
                        }

                        if (res.ok && data.status === 'success') {
                            Swal.fire({
                                title: 'Assembly Order Created!',
                                html: `<div class="bread-success"><div class="bread"></div><div class="steam success"></div><p class="mt-3 text-success">Your Order is perfectly done!</p></div>`,
                                icon: 'success',
                                confirmButtonColor: '#FFB84D',
                                background: '#fffbea',
                                customClass: {
                                    popup: 'sweet-slim'
                                },
                                showConfirmButton: true
                            });

                            bootstrap.Modal.getInstance(qs('#aoModal')).hide();
                            await fetchBOMData();
                        } else {
                            throw new Error(data.message || 'Server returned an error');
                        }

                    } catch (err) {
                        Swal.fire({
                            title: 'Oops! The oven overheated 🔥',
                            html: `<div class="bread-error"><div class="burnt-bread"></div><div class="smoke"></div><p class="mt-3 text-danger">Failed to create Assembly Order.</p></div>`,
                            icon: 'error',
                            confirmButtonColor: '#F87171',
                            background: '#fffbea',
                            customClass: {
                                popup: 'sweet-slim'
                            }
                        });
                    }
                });
            }

            // =========================
            // Auto Refresh
            // =========================
            let refreshController = null;
            let isRefreshing = false;

            async function softRefreshBOM() {
                if (isRefreshing) return;
                isRefreshing = true;

                if (refreshController) refreshController.abort();
                refreshController = new AbortController();
                const signal = refreshController.signal;

                const timeout = setTimeout(() => {
                    if (!signal.aborted) refreshController.abort();
                }, 20000);

                try {
                    const res = await fetch(`<?php echo e(route('bc.bom-with-stock')); ?>`, {
                        signal
                    });
                    if (!res.ok) throw new Error(`HTTP ${res.status}`);
                    const data = await res.json();
                    if (!signal.aborted && data?.status === 'success') {
                        window._allRecipeData = data.items;
                        renderPaginatedTable(window._filteredData || window._allRecipeData);
                    }
                } catch (err) {
                    console.warn('softRefreshBOM failed', err);
                } finally {
                    clearTimeout(timeout);
                    isRefreshing = false;
                }
            }

            // =========================
            // INITIAL LOAD
            // =========================
            await fetchBOMData();
            attachSortListeners();
            setInterval(softRefreshBOM, 30000);
        });
    </script>



    <style>
        /* === SweetAlert container refinement === */
        .swal2-popup.sweet-slim {
            width: 550px !important;
            border-radius: 20px;
            padding: 1.5rem 1.2rem;
        }

        /* ============================
                                                           🥐 Refined Pastry Animations
                                                        ============================ */
        .pastry-loader,
        .bread-success,
        .bread-error {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            animation: fadeIn 0.8s ease-in-out;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(15px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
                opacity: 1;
            }
        }

        /* === Dough Rise Animation === */
        .dough-rise {
            width: 80px;
            height: 80px;
            border-radius: 50%;
            background: radial-gradient(circle at 30% 30%, #ffe7c3, #f8c47f);
            box-shadow: inset -3px -5px 8px rgba(0, 0, 0, 0.1), 0 5px 12px rgba(0, 0, 0, 0.1);
            animation: riseRotate 2.5s ease-in-out infinite;
        }

        @keyframes riseRotate {
            0% {
                transform: scale(0.95) rotate(0deg);
            }

            50% {
                transform: scale(1.05) rotate(6deg);
            }

            100% {
                transform: scale(0.95) rotate(-6deg);
            }
        }

        /* === Success Bread === */
        .bread-success .bread {
            width: 90px;
            height: 55px;
            background: linear-gradient(to bottom, #ffcf83, #f9b760);
            border-radius: 40% 40% 35% 35%;
            box-shadow: 0 3px 6px rgba(0, 0, 0, 0.25);
            animation: breadAppear 1.2s ease-out;
            position: relative;
        }

        @keyframes breadAppear {
            0% {
                transform: scale(0.7) translateY(15px);
                opacity: 0.5;
            }

            100% {
                transform: scale(1) translateY(0);
                opacity: 1;
            }
        }

        .steam.success::before,
        .steam.success::after {
            content: '';
            position: absolute;
            width: 6px;
            height: 25px;
            background: linear-gradient(to top, rgba(255, 255, 255, 0), rgba(255, 255, 255, 0.9));
            border-radius: 50%;
            animation: steamUp 2.4s ease-in-out infinite;
            top: -30px;
        }

        .steam.success::before {
            left: -15px;
            animation-delay: 0.4s;
        }

        .steam.success::after {
            right: -15px;
            animation-delay: 1s;
        }

        @keyframes steamUp {
            0% {
                opacity: 0;
                transform: translateY(10px);
            }

            50% {
                opacity: 1;
            }

            100% {
                opacity: 0;
                transform: translateY(-25px);
            }
        }

        /* === Error Burnt Bread === */
        .bread-error .burnt-bread {
            width: 90px;
            height: 55px;
            background: linear-gradient(to bottom, #4b2c16, #3c1c0a);
            border-radius: 40% 40% 35% 35%;
            box-shadow: 0 3px 8px rgba(0, 0, 0, 0.4);
            animation: slightShake 0.8s ease-in-out;
            position: relative;
        }

        @keyframes slightShake {

            0%,
            100% {
                transform: rotate(0deg);
            }

            25% {
                transform: rotate(-2deg);
            }

            50% {
                transform: rotate(2deg);
            }

            75% {
                transform: rotate(-1deg);
            }
        }

        .smoke::before,
        .smoke::after {
            content: '';
            position: absolute;
            width: 6px;
            height: 25px;
            background: linear-gradient(to top, rgba(80, 80, 80, 0), rgba(80, 80, 80, 0.6));
            border-radius: 50%;
            animation: smokeUp 2s ease-in-out infinite;
            top: -30px;
        }

        .smoke::before {
            left: -12px;
            animation-delay: 0.3s;
        }

        .smoke::after {
            right: -12px;
            animation-delay: 1s;
        }

        @keyframes smokeUp {
            0% {
                opacity: 0;
                transform: translateY(10px);
            }

            50% {
                opacity: 0.7;
            }

            100% {
                opacity: 0;
                transform: translateY(-25px);
            }
        }
    </style>


    <style>
        .skeleton-box {
            background: linear-gradient(90deg, #f0f0f0 25%, #e0e0e0 50%, #f0f0f0 75%);
            background-size: 200% 100%;
            animation: skeleton 1.5s infinite;
            border-radius: 4px;
        }

        @keyframes skeleton {
            0% {
                background-position: 200% 0;
            }

            100% {
                background-position: -200% 0;
            }
        }

        .ingredients-card {
            transition: all 0.3s ease;
        }

        .fade-in {
            animation: fadeIn 0.3s ease-in;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(3px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .badge.bg-success-subtle {
            background-color: #90EEA2 !important;
            color: #075E0D !important;
        }

        .badge.bg-danger-subtle {
            background-color: #FCA5A5 !important;
            color: #7C1C1C !important;
        }
    </style>
    <style>
        /* =======================
                                   Pastry Themed Pagination
                                ======================= */
        .pagination {
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 6px;
            overflow-x: auto;
            padding: 0.25rem 0;
        }

        .page-item .page-link {
            border-radius: 8px;
            padding: 0.35rem 0.65rem;
            font-weight: 500;
            background: #FFF8F0;
            color: #5a3e2b;
            transition: all 0.2s ease;
            cursor: pointer;
            position: relative;
        }

        .page-item.active .page-link {
            background: #FFD6A5;
            color: #183647;
            transform: scale(1.2);
            font-weight: 600;
        }

        .page-link:hover {
            transform: scale(1.1) translateY(-2px);
            background: #FFE8C1;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.15);
        }

        .page-item.disabled .page-link {
            cursor: not-allowed;
            opacity: 0.5;
            transform: none !important;
        }

        /* Slide & fade animation for table rows */
        .fade-out {
            opacity: 0;
            transform: translateY(8px);
            transition: all 0.18s ease-in;
        }

        .fade-in {
            opacity: 1;
            transform: translateY(0);
            transition: all 0.28s ease-out;
        }
    </style>
    <style>
        /* Wrapper agar table tidak overflow horisontal */
        .table-responsive-nice {
            width: 100%;
            overflow-x: auto;
        }

        /* Header tidak boleh membungkus */
        #recipesTable th {
            white-space: nowrap;
            font-size: 0.88rem;
            /* konsisten, tidak kecil berlebihan */
        }

        /* Body bisa mengecil saat sempit */
        @media (max-width: 1600px) {
            #recipesTable td {
                font-size: 0.78rem;
            }
        }

        /* Batasi kolom yang rawan overflow */


        /* Progress bar container tidak membuat lebar naik */
        .progress-small {
            max-width: 160px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/pawc5944/public_html/butcher/resources/views/transferheader.blade.php ENDPATH**/ ?>