<?php

namespace App\Http\Controllers;

use App\Models\ItemRequest;
use App\Models\ItemRequestComment;
use Illuminate\Http\Request;
use App\Support\CommentNotifier;

class ItemRequestCommentController extends Controller
{
    public function store(Request $request, $requestId)
    {
        // Validasi input
        $request->validate([
            'body' => 'required|string|max:2000',
        ]);

        // Cari request utama
        $itemRequest = ItemRequest::findOrFail($requestId);

        // Simpan komentar
        $comment = ItemRequestComment::create([
            'item_request_id' => $itemRequest->id,
            'user_id' => auth()->id(),
            'body' => $request->input('body'),
        ]);

        // Kirim notifikasi email ke pemilik request
        CommentNotifier::send($comment);

        // Redirect balik ke halaman detail
        return redirect()
            ->route('approvals.show', $itemRequest->id)
            ->with('success', 'Comment added.');
    }
}
