@extends('layouts.print')
@section('title','Print — Request #'.$req->id)

@push('styles')
@push('styles')
<style>
  /* Fit full width of A4 landscape */
  @page { size: A4 landscape; margin: 8mm; } /* smaller margin gives more width */
  @media print { body { -webkit-print-color-adjust: exact; print-color-adjust: exact; } }
  html,body{width:100%; max-width:100%}
  body{ font-family: Tahoma, Arial, sans-serif; color:#002b2b; }

  .sheet-title{ text-align:center; font-size:22px; font-weight:700; letter-spacing:.5px; margin:0 0 8px; }
  .header-row{ display:flex; align-items:flex-start; justify-content:space-between; margin:0 0 6px; padding:0 2mm; }
  .vendor-name{ font-size:12px; font-weight:600; }
  .logos{ display:flex; gap:8px; align-items:center; }
  .logos img{ height:38px; }

  table.grid{ width:100%; border-collapse:collapse; table-layout:fixed; }
  table.grid th, table.grid td{ border:1px solid #3b5c5c; padding:6px 6px; font-size:12px; vertical-align:middle; word-wrap:break-word; }
  thead.primary th{ background:#0c3c3d; color:#fff; font-weight:700; text-align:center; }
  thead.secondary th{ background:#e7f1ee; color:#002b2b; font-weight:700; text-align:center; }

  .cmp-head,.coa-head{ background:#0c3c3d; color:#fff; }
  .chosen-vendor{ color:#c21f2f; font-weight:700; }
  .muted{ color:#6b7a7a; }
  .right{ text-align:right; }
  .center{ text-align:center; }

  .sig-wrap{ margin-top:12px; padding:0 2mm; }
  .sig-grid{ width:100%; border-collapse:collapse; table-layout:fixed; }
  .sig-grid td{ border:0; vertical-align:top; padding:8px; }
  .sig-box{ height:90px; border:1px dashed #9cb0b0; border-radius:10px; display:flex; align-items:center; justify-content:center; background:#fff; }
  .sig-box img{ max-height:80px; max-width:100%; object-fit:contain; }
  .sig-title{ font-weight:600; margin-top:6px; }
  .sig-role{ font-size:12px; color:#6b7a7a; }
  .legend{ margin-top:8px; font-size:10px; color:#6b7a7a; }
</style>
@endpush

@section('content')
<div class="container-fluid my-2">
  <h2 class="sheet-title">NEW ITEM REQUEST FORM</h2>

  <div class="header-row">
    <div class="vendor-name">
      VENDOR NAME : <span class="chosen-vendor">
        {{ $req->vendor_name ?: ($vendorHeader[0] ?? '—') }}
      </span>
    </div>
    @php $base = request()->getSchemeAndHttpHost().request()->getBaseUrl(); @endphp
    <div class="logos">
      <img src="{{ $base }}/public/storage/images/logo_ci.png" alt="CI">
      <img src="{{ $base }}/public/storage/images/logo_regent.png" alt="Regent">
      <img src="{{ $base }}/public/storage/images/logo_hic.png" alt="HIC">
    </div>
  </div>

  <table class="grid">
    <colgroup>
    <col style="width:18%">  {{-- Article Name --}}
    <col style="width:7%">   {{-- Base of Unit --}}
    <col style="width:8%">   {{-- Type --}}
    <col style="width:8%">   {{-- Chosen Vendor --}}
    <col style="width:8%">   {{-- Vendor 2 --}}
    <col style="width:8%">   {{-- Vendor 3 --}}
    <col style="width:16%">  {{-- Remarks --}}
    <col style="width:4.5%"> {{-- Inventory Posting Group --}}
    <col style="width:4.5%"> {{-- Gen. Prod. Posting Group --}}
    <col style="width:4.5%"> {{-- Account Code --}}
    <col style="width:4.5%"> {{-- L1 --}}
    <col style="width:4.5%"> {{-- L2 --}}
    <col style="width:4.5%"> {{-- Article No. --}}
  </colgroup>
  <thead class="primary">
    <tr>
      <th rowspan="2">Article Name</th>
      <th rowspan="2">Base of Unit</th>
      <th rowspan="2">Type</th>
      <th class="cmp-head" colspan="3">Comparison Price</th>
      <th rowspan="2">Remarks</th>
      <th class="coa-head" colspan="6">COA (HOTEL FINANCE ONLY)</th>
    </tr>
    <tr>
      <th>Chosen Vendor</th>
      <th>Vendor 2</th>
      <th>Vendor 3</th>
      <th>Inventory Posting Group</th>
      <th>Gen. Prod. Posting Group</th>
      <th>Account Code</th>
      <th>L1</th>
      <th>L2</th>
      <th>Article No.</th>
    </tr>
    </thead>

    <tbody>
      @php
        $padTo = max(10, $req->lines->count()); // pad to 10 rows for a full page look
      @endphp

      @foreach($req->lines as $l)
        @php
          $quotes = collect($l->vendor_quotes ?? []);
          $sel = $quotes->firstWhere('selected', true) ?? $quotes->first();
          $others = $quotes->filter(function($q) use($sel){
              return ($q['name'] ?? null) !== ($sel['name'] ?? null);
          })->values();
          $q2 = $others->get(0);
          $q3 = $others->get(1);

          // simple helpers
          $fmt = function($q){
            if (!$q) return '—';
            $ccy = $q['currency'] ?? 'IDR';
            $p   = is_numeric($q['price'] ?? null) ? number_format((float)$q['price'], 0) : '—';
            return "{$ccy} {$p}";
          };
        @endphp
        <tr>
          <td>{{ $l->article_name }}</td>
          <td class="center">{{ $l->base_unit_code }}</td>
          <td class="center">{{ $l->type }}</td>

          <td class="center">
            <div class="chosen-vendor">{{ $sel['name'] ?? '—' }}</div>
            <div class="muted">{{ $fmt($sel) }}</div>
          </td>
          <td class="center">
            <div>{{ $q2['name'] ?? '—' }}</div>
            <div class="muted">{{ $fmt($q2) }}</div>
          </td>
          <td class="center">
            <div>{{ $q3['name'] ?? '—' }}</div>
            <div class="muted">{{ $fmt($q3) }}</div>
          </td>

          <td>{{ $l->line_remarks }}</td>
          <td class="center">{{ $l->inventory_posting_group_code ?: '—' }}</td>
          <td class="center">{{ $l->gen_prod_posting_group_code ?: '—' }}</td>
          <td class="center">{{ $l->gl_account_no ?: '—' }}</td>
          <td class="center">{{ $l->l1 ?: '—' }}</td>
          <td class="center">{{ $l->l2 ?: '—' }}</td>
          <td class="center">{{ $l->article_no ?: '—' }}</td>
        </tr>
      @endforeach

      {{-- Pad blank rows to keep the grid height like your sheet --}}
      @for($i=$req->lines->count(); $i<$padTo; $i++)
        <tr>
          <td>&nbsp;</td><td></td><td></td>
          <td></td><td></td><td></td>
          <td></td><td></td><td></td><td></td><td></td><td></td><td></td>
        </tr>
      @endfor
    </tbody>
  </table>

  {{-- SIGNATURES --}}
  <div class="sig-wrap">
    @php
      $base = request()->getSchemeAndHttpHost().request()->getBaseUrl();
    
      $sigUrl = function (?int $userId) use ($base) {
        if (!$userId) return null;
        $rel = "storage/signatures/{$userId}.png";
        $fs  = public_path($rel);
        return file_exists($fs) ? "{$base}/public/{$rel}" : null;
      };
      
      $preparedId  = $req->requester?->id;
      $preparedUrl = $sigUrl($req->requester?->id);
    
      $acts = optional($req->instance)->actions ?? collect();
    
      $approveActs = $acts->where('action', 'Approve')->sortBy('acted_at')->values();
    
      $uniqueApprovers = collect();
      $seenActorIds = collect();
    
      foreach ($approveActs as $act) {
        $actorId = $act->actor?->id;
        if (!$actorId) continue;
        if ($actorId === $preparedId) continue; 
        if ($seenActorIds->contains($actorId)) continue; 
        $seenActorIds->push($actorId);
        $uniqueApprovers->push($act);
        if ($uniqueApprovers->count() >= 3) break;
      }
    
      $approver1 = $uniqueApprovers->get(0);
      $approver2 = $uniqueApprovers->get(1);
      $approver3 = $uniqueApprovers->get(2);
    
      $url1 = $sigUrl($approver1?->actor?->id);
      $url2 = $sigUrl($approver2?->actor?->id);
      $url3 = $sigUrl($approver3?->actor?->id);
    @endphp
    
    <table class="sig-grid">
      <tr>
        {{-- Prepared by --}}
        <td>
          <div class="sig-box">
            @if($preparedUrl)
              <img src="{{ $preparedUrl }}" alt="signature">
            @else
              <span class="muted">— signature —</span>
            @endif
          </div>
          <div class="sig-title">Prepared by,</div>
          <div>{{ $req->requester?->name ?? '—' }}</div>
          <div class="sig-role">Purchasing / Requester</div>
        </td>
    
        {{-- 1st Approver --}}
        <td>
          <div class="sig-box">
            @if($url1)
              <img src="{{ $url1 }}" alt="signature">
            @else
              <span class="muted">— signature —</span>
            @endif
          </div>
          <div class="sig-title">Checked By,</div>
          <div>{{ $approver1?->actor?->name ?? '—' }}</div>
          <div class="sig-role">Manager Operational</div>
        </td>
    
        {{-- 2nd Approver --}}
        <td>
          <div class="sig-box">
            @if($url2)
              <img src="{{ $url2 }}" alt="signature">
            @else
              <span class="muted">— signature —</span>
            @endif
          </div>
          <div class="sig-title">Approved By,</div>
          <div>{{ $approver2?->actor?->name ?? '—' }}</div>
          <div class="sig-role">Costing Team</div>
        </td>
    
        {{-- 3rd Approver --}}
        <td>
          <div class="sig-box">
            @if($url3)
              <img src="{{ $url3 }}" alt="signature">
            @else
              <span class="muted">— signature —</span>
            @endif
          </div>
          <div class="sig-title">Created By,</div>
          <div>{{ $approver3?->actor?->name ?? '—' }}</div>
          <div class="sig-role">Owning Company</div>
        </td>
      </tr>
    </table>
    
      <div class="legend">
        Submit with supporting document (Invoices).<br>
      </div>
    </div>

</div>
@if(request('autoprint'))
  @push('scripts')<script>window.print()</script>@endpush
@endif
@endsection
