<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
      Schema::create('roles', function (Blueprint $t) {
        $t->id();
        $t->string('name')->unique();
        $t->string('code')->unique();
        $t->timestamps();
      });
      DB::table('roles')->insert([
        [
            'name' => 'USER',
            'code' => 'USER',
            'created_at' => now(),
            'updated_at' => now(),
        ],
        [
            'name' => 'APPROVER',
            'code' => 'APPROVER',
            'created_at' => now(),
            'updated_at' => now(),
        ],
        [
            'name' => 'ADMIN',
            'code' => 'ADMIN',
            'created_at' => now(),
            'updated_at' => now(),
        ],
    ]);
  }
  public function down(): void { Schema::dropIfExists('roles'); }
};
