from flask import Flask, request, send_file
import fitz  # PyMuPDF
from reportlab.lib.units import mm
import tempfile
import os

app = Flask(__name__)

@app.route("/", methods=["POST"])
def sign():
    import tempfile, os
    import fitz
    from reportlab.lib.units import mm
    from flask import request, send_file

    # =============================
    # INPUT VALIDATION
    # =============================
    pdf_file = request.files.get("pdf")
    signature_file = request.files.get("signature")
    target_text = request.form.get("signer")

    if not pdf_file or not signature_file or not target_text:
        return "Missing parameters", 400

    # =============================
    # TEMP FILES
    # =============================
    tmp_in = tempfile.NamedTemporaryFile(delete=False, suffix=".pdf")
    tmp_sig = tempfile.NamedTemporaryFile(delete=False, suffix=".png")
    tmp_out = tempfile.NamedTemporaryFile(delete=False, suffix=".pdf")

    pdf_file.save(tmp_in.name)
    signature_file.save(tmp_sig.name)

    # =============================
    # SIGN PDF
    # =============================
    doc = fitz.open(tmp_in.name)
    signature_placed = False

    # ---- TRY TEXT-BASED SIGN ----
    for page in doc:
        text_instances = page.search_for(target_text)

        for rect in text_instances:
            sig_width = 400
            sig_height = 200

            x = rect.x0 - 150
            y = rect.y0 - sig_height + 50

            page.insert_image(
                fitz.Rect(x, y, x + sig_width, y + sig_height),
                filename=tmp_sig.name
            )

            signature_placed = True

    # ---- FALLBACK: SIGN ALL PAGES ----
    if not signature_placed:
        for page in doc:
            width = page.rect.width
            height = page.rect.height

            sig_w = 140 * mm
            sig_h = 70 * mm

            x = width - sig_w - 40
            y = height - sig_h - 120

            page.insert_image(
                fitz.Rect(x, y, x + sig_w, y + sig_h),
                filename=tmp_sig.name
            )

    # =============================
    # SAFE SAVE (NO CORRUPTION)
    # =============================
    doc.save(
        tmp_out.name,
        garbage=4,
        deflate=True,
        clean=True
    )
    doc.close()

    # =============================
    # RESPONSE
    # =============================
    response = send_file(
        tmp_out.name,
        as_attachment=True,
        download_name="signed.pdf",
        mimetype="application/pdf"
    )

    # =============================
    # CLEANUP (IMPORTANT)
    # =============================
    @response.call_on_close
    def cleanup():
        for f in (tmp_in.name, tmp_sig.name, tmp_out.name):
            try:
                os.remove(f)
            except:
                pass

    return response
    

@app.route("/signed", methods=["POST"])
def signurl():
    print("FLASK WAS HIT")
    return "OK"