<!DOCTYPE html>
<html lang="en" x-data="theme()" x-init="init()">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo $__env->yieldContent('title', 'Analytics Portal'); ?></title>

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Icons -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

    <!-- Alpine -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

    <style>
        :root {
            --primary: #2563eb;
            --accent: #22c55e;
            --bg: #f8fafc;
            --card: #ffffff;
            --text: #0f172a;
            --muted: #64748b;
        }

        body {
            background: var(--bg);
            color: var(--text);
        }

        body[data-theme="dark"] {
            --bg: #0f172a;
            --card: #020617;
            --text: #e5e7eb;
            --muted: #94a3b8;
            background: var(--bg);
            color: var(--text);
        }

        /* Navbar */
        .navbar {
            background: var(--card);
            border-bottom: 1px solid rgba(0,0,0,.05);
        }

        .navbar-brand {
            font-weight: 700;
            letter-spacing: .3px;
        }

        .nav-link {
            color: var(--muted);
            font-weight: 500;
        }

        .nav-link.active,
        .nav-link:hover {
            color: var(--primary);
        }

        /* Page container */
        .page-wrapper {
            padding-top: 2rem;
            padding-bottom: 2rem;
        }

        /* Card */
        .card-soft {
            background: var(--card);
            border-radius: 1rem;
            border: none;
            box-shadow: 0 10px 28px rgba(0,0,0,.06);
        }

        /* Company switcher */
        .company-pill {
            background: rgba(37,99,235,.1);
            color: var(--primary);
            border-radius: 999px;
            padding: 6px 14px;
            font-weight: 600;
            border: none;
        }

        body[data-theme="dark"] .company-pill {
            background: rgba(37,99,235,.2);
        }

        /* Footer */
        footer {
            color: var(--muted);
        }
    </style>

    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body :data-theme="mode">

<!-- NAVBAR -->
    <nav class="navbar navbar-expand-lg navbar-light bg-white sticky-top shadow-sm">
        <div class="container-fluid">

            <!-- Brand -->
            <a class="navbar-brand d-flex align-items-center gap-2" href="<?php echo e(route('forms.page')); ?>">
                <i class="fa-solid fa-chart-line text-primary"></i>
                <span>Payment Request</span>
            </a>

            <!-- Toggler -->
            <button class="navbar-toggler border-0" type="button" data-bs-toggle="collapse" data-bs-target="#nav">
                <span class="navbar-toggler-icon"></span>
            </button>

            <!-- Navbar links -->
            <div class="collapse navbar-collapse" id="nav">
                <ul class="navbar-nav ms-auto align-items-center gap-2">

                    <!-- Upload PDFs -->
                    <?php if(session('user')): ?>
                        <li class="nav-item">
                            <a href="<?php echo e(route('forms.page')); ?>" class="btn btn-sm btn-outline-primary">
                                <i class="fa-solid fa-upload me-1"></i> Upload PDFs
                            </a>
                        </li>

                        <!-- Signed PDFs -->
                        <li class="nav-item">
                            <a href="<?php echo e(route('forms.signed')); ?>" class="btn btn-sm btn-outline-success">
                                <i class="fa-solid fa-file-signature me-1"></i> Signed PDFs
                            </a>
                        </li>
                         <?php if(session('user.role') === 'ADMIN'): ?>
                            <li class="nav-item">
                                <a href="<?php echo e(route('admin.users')); ?>" class="btn btn-sm btn-outline-dark">
                                    <i class="fa-solid fa-users-cog me-1"></i> Manage Users
                                </a>
                            </li>

                            <li class="nav-item">
                                <a href="<?php echo e(route('admin.users.create')); ?>" class="btn btn-sm btn-outline-primary">
                                    <i class="fa-solid fa-user-plus me-1"></i> Add User
                                </a>
                            </li>
                        <?php endif; ?>
                    <?php endif; ?>

                    <!-- Theme Toggle -->
                    <li class="nav-item">
                        <button class="btn btn-sm btn-outline-secondary" @click="toggle()">
                            <i :class="mode === 'dark' ? 'fa-solid fa-sun' : 'fa-solid fa-moon'"></i>
                        </button>
                    </li>

                    <!-- User Email -->
                    <?php if(session('user')): ?>
                        <li class="nav-item">
                            <span class="small text-muted d-flex align-items-center gap-1">
                                <i class="fa-solid fa-user"></i> <?php echo e(data_get(session('user'), 'email')); ?>

                            </span>
                        </li>
                    <?php endif; ?>

                </ul>
            </div>
        </div>
    </nav>

<!-- CONTENT -->
<main class="page-wrapper">
    <div class="container">
        <?php echo $__env->yieldContent('content'); ?>
    </div>
</main>

<!-- FOOTER -->
<footer class="py-4 text-center small">
    &copy; <?php echo e(date('Y')); ?> Analytics Portal
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
function theme() {
    return {
        mode: localStorage.getItem('theme') || 'light',
        init() { this.apply() },
        toggle() {
            this.mode = this.mode === 'light' ? 'dark' : 'light'
            localStorage.setItem('theme', this.mode)
            this.apply()
        },
        apply() {
            document.body.setAttribute('data-theme', this.mode)
        }
    }
}
</script>

<?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html>
<?php /**PATH /home/pawc5944/public_html/payment-req/resources/views/layouts/app.blade.php ENDPATH**/ ?>