<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
  public function up(): void {
    Schema::create('approval_instances', function (Blueprint $t) {
      $t->id();
      $t->foreignId('item_request_id')->constrained()->cascadeOnDelete();
      $t->foreignId('flow_template_id')->constrained('approval_flow_templates');
      $t->timestamp('started_at')->useCurrent();
      $t->timestamp('ended_at')->nullable();
      $t->string('status')->default('InProgress');
      $t->timestamps();
      $t->unique('item_request_id'); // one active instance per request
    });

    Schema::create('approval_actions', function (Blueprint $t) {
      $t->id();
      $t->foreignId('approval_instance_id')->constrained()->cascadeOnDelete();
      $t->unsignedInteger('step_no');
      $t->foreignId('actor_user_id')->constrained('users');
      $t->enum('action',['Submit','Approve','Reject','Cancel','RequestChanges','Reassign']);
      $t->text('comment')->nullable();
      $t->timestamp('acted_at')->useCurrent();
      $t->timestamps();
      $t->index(['approval_instance_id','step_no']);
    });
  }
  public function down(): void {
    Schema::dropIfExists('approval_actions');
    Schema::dropIfExists('approval_instances');
  }
};
