<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('vendor_request_lines', function (Blueprint $table) {
            $table->id();
            
            // Relasi ke item_requests
            $table->foreignId('item_request_id')
                  ->constrained('item_requests')
                  ->onDelete('cascade');
            
            // Relasi ke company
            $table->foreignId('company_id')
                  ->constrained('companies')
                  ->onDelete('cascade');
            
            // Data vendor
            $table->string('vendor_name', 255);
            $table->string('npwp', 50)->nullable();
            $table->string('phone', 20)->nullable();
            $table->text('address')->nullable();

            // Bank info
            $table->string('bank_name', 100);
            $table->string('account_holder', 100);
            $table->string('account_number', 50);
            
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('vendor_request_lines');
    }
};
