<!DOCTYPE html>
<html lang="en" x-data="theme()" x-init="init()">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>@yield('title', 'Analytics Portal')</title>

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Icons -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

    <!-- Alpine -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

    <style>
        :root {
            --primary: #2563eb;
            --accent: #22c55e;
            --bg: #f8fafc;
            --card: #ffffff;
            --text: #0f172a;
            --muted: #64748b;
        }

        body {
            background: var(--bg);
            color: var(--text);
        }

        body[data-theme="dark"] {
            --bg: #0f172a;
            --card: #020617;
            --text: #e5e7eb;
            --muted: #94a3b8;
            background: var(--bg);
            color: var(--text);
        }

        /* Navbar */
        .navbar {
            background: var(--card);
            border-bottom: 1px solid rgba(0,0,0,.05);
        }

        .navbar-brand {
            font-weight: 700;
            letter-spacing: .3px;
        }

        .nav-link {
            color: var(--muted);
            font-weight: 500;
        }

        .nav-link.active,
        .nav-link:hover {
            color: var(--primary);
        }

        /* Page container */
        .page-wrapper {
            padding-top: 2rem;
            padding-bottom: 2rem;
        }

        /* Card */
        .card-soft {
            background: var(--card);
            border-radius: 1rem;
            border: none;
            box-shadow: 0 10px 28px rgba(0,0,0,.06);
        }

        /* Company switcher */
        .company-pill {
            background: rgba(37,99,235,.1);
            color: var(--primary);
            border-radius: 999px;
            padding: 6px 14px;
            font-weight: 600;
            border: none;
        }

        body[data-theme="dark"] .company-pill {
            background: rgba(37,99,235,.2);
        }

        /* Footer */
        footer {
            color: var(--muted);
        }
    </style>

    @stack('styles')
</head>

<body :data-theme="mode">

<!-- NAVBAR -->
<nav class="navbar navbar-expand-lg sticky-top">
    <div class="container-fluid">

        <a class="navbar-brand d-flex align-items-center gap-2" href="#">
            <i class="fa-solid fa-chart-line text-primary"></i>
            <span>Analytics Portal</span>
        </a>

        <button class="navbar-toggler border-0" data-bs-toggle="collapse" data-bs-target="#nav">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse" id="nav">

            <!-- Left -->
            <ul class="navbar-nav me-auto gap-2">
                <li class="nav-item">
                    <a class="nav-link {{ request()->routeIs('dashboards.index') ? 'active' : '' }}"
                       href="{{ route('dashboards.index') }}">
                        Dashboards
                    </a>
                </li>
            </ul>

            <!-- Right -->
            <ul class="navbar-nav align-items-center gap-3">

                {{-- <!-- Company -->
                <li class="nav-item dropdown">
                    <button class="company-pill dropdown-toggle" data-bs-toggle="dropdown">
                        <i class="fa-solid fa-building me-1"></i>
                        {{ session('current_company_name') }}
                    </button>

                    <ul class="dropdown-menu dropdown-menu-end shadow-sm">
                        <li>
                            <a class="dropdown-item" href="{{ route('switch-company', ['type' => 'Regent']) }}">
                                Regent
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="{{ route('switch-company', ['type' => 'HIN']) }}">
                                HIN
                            </a>
                        </li>
                    </ul>
                </li> --}}

                <!-- Theme -->
                <li class="nav-item">
                    <button class="btn btn-sm btn-outline-secondary" @click="toggle()">
                        <i :class="mode === 'dark' ? 'fa-solid fa-sun' : 'fa-solid fa-moon'"></i>
                    </button>
                </li>

                <!-- User -->
                @if (session('user'))
                    <li class="nav-item small text-muted">
                        <i class="fa-solid fa-user me-1"></i>
                        {{ data_get(session('user'), 'email') }}
                    </li>
                @endif
            </ul>
        </div>
    </div>
</nav>

<!-- CONTENT -->
<main class="page-wrapper">
    <div class="container">
        @yield('content')
    </div>
</main>

<!-- FOOTER -->
<footer class="py-4 text-center small">
    &copy; {{ date('Y') }} Analytics Portal
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
function theme() {
    return {
        mode: localStorage.getItem('theme') || 'light',
        init() { this.apply() },
        toggle() {
            this.mode = this.mode === 'light' ? 'dark' : 'light'
            localStorage.setItem('theme', this.mode)
            this.apply()
        },
        apply() {
            document.body.setAttribute('data-theme', this.mode)
        }
    }
}
</script>

@stack('scripts')
</body>
</html>
