<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PoRekap extends Model
{
    protected $table = 'po_rekap';

    protected $fillable = [
        'document_no',
        'company',
        'category',
        'document_date',
        'buy_from_vendor_name',
        'shortcut_dimension_1_code',
        'amount',
        'amount_including_vat',
        'approver_id',
        'document_type',
        'status',
        'auxiliary_index1',
        'auxiliary_index2',
    ];

    protected $casts = [
        'document_date' => 'date',
        'amount' => 'decimal:2',
        'amount_including_vat' => 'decimal:2',
    ];

    public function details()
    {
        return $this->hasMany(PoDetail::class, 'document_no', 'document_no')
                    ->where('company', $this->company)
                    ->where('category', $this->category);
    }
}