@extends('layouts.dashboard')

@section('title', $company . ' - ' . $category . ' - PO Approval System')
@section('page-title', $company . ' - ' . str_replace('_', ' ', $category))

@section('content')
<style>
    .no-api-container {
        background: white;
        border-radius: 15px;
        padding: 60px 40px;
        text-align: center;
        box-shadow: var(--shadow);
        max-width: 600px;
        margin: 100px auto;
    }

    .no-api-icon {
        width: 100px;
        height: 100px;
        margin: 0 auto 30px;
        background: linear-gradient(135deg, #ffc107 0%, #ff9800 100%);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .no-api-icon svg {
        width: 50px;
        height: 50px;
        fill: white;
    }

    .no-api-container h2 {
        font-size: 28px;
        color: var(--text-dark);
        margin-bottom: 15px;
    }

    .no-api-container p {
        font-size: 16px;
        color: var(--text-light);
        margin-bottom: 30px;
        line-height: 1.6;
    }

    .info-box {
        background: #fff3cd;
        border: 1px solid #ffc107;
        border-radius: 10px;
        padding: 20px;
        margin-top: 30px;
        text-align: left;
    }

    .info-box h4 {
        color: #856404;
        font-size: 16px;
        margin-bottom: 10px;
    }

    .info-box ul {
        color: #856404;
        padding-left: 20px;
        margin: 0;
    }

    .info-box li {
        margin-bottom: 8px;
    }
</style>

<div class="no-api-container">
    <div class="no-api-icon">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24">
            <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"/>
        </svg>
    </div>

    <h2>API Not Available</h2>
    <p>The API endpoint for <strong>{{ str_replace('_', ' ', $category) }}</strong> is currently not available or under development.</p>

    <a href="{{ route('dashboard') }}" class="btn btn-primary">
        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" style="margin-right: 8px;">
            <path d="M20 11H7.83l5.59-5.59L12 4l-8 8 8 8 1.41-1.41L7.83 13H20v-2z" fill="currentColor"/>
        </svg>
        Back to Dashboard
    </a>

    <div class="info-box">
        <h4>What you can do:</h4>
        <ul>
            <li>Check other available categories</li>
            <li>Contact system administrator for API availability</li>
            <li>Review approval history for completed transactions</li>
        </ul>
    </div>
</div>
@endsection