<?php

namespace App\Http\Controllers\Hirbnd;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class StandardController extends Controller
{
    /**
     * Show standard room types
     */
    public function index()
    {
        $roomTypes = config('businesscentral.room_types.standard');
        
        // Get room counts untuk setiap room type dari database
        $roomCounts = [];
        
        foreach ($roomTypes as $key => $type) {
            // ✅ FIX: Ambil HANYA room yang RoomType = $key
            $count = DB::table('january_hirbnd')
                ->where('RoomType', $key)
                ->distinct()
                ->count('Room');
            
            $roomCounts[$key] = $count;
            
            Log::info("Standard Room Type Count", [
                'room_type' => $key,
                'count' => $count
            ]);
        }
        
        // ✅ FIX: Jangan lupa pass $roomCounts ke view!
        return view('hirbnd.standard', compact('roomTypes', 'roomCounts'));
    }

    /**
     * Show specific room type with rooms
     */
    public function showRoomType($roomType)
    {
        $roomTypes = config('businesscentral.room_types.standard');
        
        if (!isset($roomTypes[$roomType])) {
            abort(404, "Room type {$roomType} not found");
        }

        $roomTypeName = $roomTypes[$roomType];

        // ✅ FIX: Ambil list room HANYA untuk RoomType ini!
        $rooms = DB::table('january_hirbnd')
            ->where('RoomType', $roomType)
            ->select('Room')
            ->distinct()
            ->orderByRaw('CAST(Room AS UNSIGNED)')
            ->pluck('Room')
            ->toArray();

        Log::info("Standard Room Type Detail", [
            'room_type' => $roomType,
            'room_type_name' => $roomTypeName,
            'total_rooms' => count($rooms),
            'rooms' => $rooms
        ]);

        return view('hirbnd.room-type', compact('roomType', 'roomTypeName', 'rooms'));
    }

    /**
 * Show room matrix data - PAKAI DATA REAL!
 */
public function showRoomMatrix($roomType, $room)
{
    $roomTypes = config('businesscentral.room_types.standard');
    
    if (!isset($roomTypes[$roomType])) {
        abort(404, "Room type {$roomType} not found");
    }

    $roomTypeName = $roomTypes[$roomType];

    // ✅ AMBIL DATA REAL dari 12 monthly tables!
    $months = [
        'january', 'february', 'march', 'april', 'may', 'june',
        'july', 'august', 'september', 'october', 'november', 'december'
    ];

    $monthlyData = [];

    foreach ($months as $month) {
        $data = DB::table("{$month}_hirbnd")
            ->where('Room', $room)
            ->where('RoomType', $roomType)
            ->get();

        $monthlyData[$month] = $data;
    }

    return view('hirbnd.room-matrix', compact('roomType', 'roomTypeName', 'room', 'monthlyData'));
}
}