<?php

namespace App\Models\Hirbnd;

use Illuminate\Database\Eloquent\Model;

class OooHirbnd extends Model
{
    protected $table = 'ooo_hirbnd';

    protected $fillable = [
        'odata_etag',
        'AuxiliaryIndex1',
        'Begin_Date',
        'Business_Unit',
        'Completed_On',
        'End_Date',
        'Label',
        'Reason_Code',
        'Reason_Desc',
        'Repair_Remark',
        'Return_Status',
        'Room_Class',
        'Room_No',
        'Room_Status',
    ];

    protected $casts = [
        'Begin_Date' => 'date',
        'Completed_On' => 'date',
        'End_Date' => 'date',
        'AuxiliaryIndex1' => 'integer',
    ];

    /**
     * Scope untuk filter by room number
     */
    public function scopeByRoom($query, string $roomNo)
    {
        return $query->where('Room_No', $roomNo);
    }

    /**
     * Scope untuk filter by reason code
     */
    public function scopeByReasonCode($query, string $reasonCode)
    {
        return $query->where('Reason_Code', $reasonCode);
    }

    /**
     * Scope untuk OOO aktif (Completed_On = '0001-01-01')
     */
    public function scopeActive($query)
    {
        return $query->where('Completed_On', '0001-01-01');
    }

    /**
     * Scope untuk filter by business unit
     */
    public function scopeByBusinessUnit($query, string $businessUnit = 'HIRBND')
    {
        return $query->where('Business_Unit', $businessUnit);
    }

    /**
     * Check apakah OOO masih aktif
     */
    public function isActive(): bool
    {
        return $this->Completed_On == '0001-01-01';
    }

    /**
     * Get formatted repair remark
     */
    public function getFormattedRemarkAttribute(): string
    {
        return $this->Repair_Remark ? str_replace('//', ' - ', $this->Repair_Remark) : '-';
    }
}