<?php

namespace App\Models\Regent;

use Illuminate\Database\Eloquent\Model;

class RegentMonthly extends Model
{
    // This is a base model, actual table will be set dynamically
    // Example: (new RegentMonthly)->setTable('january_regent')
    
    protected $fillable = [
        'Business_Unit',
        'Room',
        'RoomType',
        'Posting_Date',
        'Guest_Full_Name',
        'Market_Code',
        'TRX_Code',
        'TRX_Desc',
        'Amount_1',
        'Interval',
        'No_Asset',
        'Row_No',
        'odata_etag',
    ];

    protected $casts = [
        'Posting_Date' => 'date',
        'Amount_1' => 'decimal:2',
        'Row_No' => 'integer',
    ];

    /**
     * Set the table dynamically based on month
     */
    public function setMonth($month)
    {
        $this->setTable("{$month}_regent");
        return $this;
    }
}