<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email')->unique();
            $table->string('password');
            $table->enum('company', ['hirbnd', 'regent', 'hirbc'])->nullable();
            $table->tinyInteger('is_data_loaded')->default(0)->comment('0=belum load, 1=sudah load');
            $table->timestamp('last_data_load')->nullable()->comment('Timestamp terakhir load data');
            $table->rememberToken();
            $table->timestamps();

            $table->index('email');
            $table->index('is_data_loaded');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};